/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces;

public enum NodeStatus {
    NotDone("Not Done", "This file is not processed yet."),
    Identified("Identified", "Positive identification"),
    NotIdentified("Not Identified", "This file could not be identifed"),
    MultipleIdentification("Multiple Identification", "Droid has identified more then one file type for this file."),
    Error("Error", "An error has occurred while processing the file.");

    private String status;
    private String statusDescription;

    private NodeStatus(String status, String statusDescription) {
        this.status = status;
        this.statusDescription = statusDescription;
    }

    public long getId() {
        return this.ordinal();
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public static NodeStatus forResultSize(int size) {
        NodeStatus status;
        switch (size) {
            case 0: {
                status = NotIdentified;
                break;
            }
            case 1: {
                status = Identified;
                break;
            }
            default: {
                status = MultipleIdentification;
            }
        }
        return status;
    }
}

