/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FilenameUtils;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class GZipArchiveHandler
implements ArchiveHandler {
    private IdentificationRequestFactory factory;
    private AsynchDroid droid;

    @Override
    public void handle(IdentificationRequest request) throws IOException {
        InputStream in = request.getSourceInputStream();
        URI parent = request.getIdentifier().getUri();
        long correlationId = request.getIdentifier().getNodeId();
        GzipCompressorInputStream gzin = new GzipCompressorInputStream(in);
        URI uri = ArchiveFileUtils.toGZipUri(parent);
        String path = uri.getSchemeSpecificPart();
        String fileName = FilenameUtils.getName((String)path);
        RequestMetaData metaData = new RequestMetaData(null, null, fileName);
        RequestIdentifier identifier = new RequestIdentifier(uri);
        identifier.setAncestorId(request.getIdentifier().getAncestorId());
        identifier.setParentId(correlationId);
        IdentificationRequest archiveRequest = this.factory.newRequest(metaData, identifier);
        archiveRequest.open((InputStream)gzin);
        this.droid.submit(archiveRequest);
    }

    public void setFactory(IdentificationRequestFactory factory) {
        this.factory = factory;
    }

    public void setDroidCore(AsynchDroid droidCore) {
        this.droid = droidCore;
    }
}

