/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileWalker;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveInputStreamIterator;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class TarArchiveHandler
implements ArchiveHandler {
    private AsynchDroid droidCore;
    private IdentificationRequestFactory factory;
    private ResultHandler resultHandler;

    @Override
    public void handle(IdentificationRequest request) throws IOException {
        InputStream tarIn = request.getSourceInputStream();
        URI parentName = request.getIdentifier().getUri();
        long parentId = request.getIdentifier().getNodeId();
        final TarArchiveInputStream in = new TarArchiveInputStream(tarIn);
        Iterable<TarArchiveEntry> iterable = new Iterable<TarArchiveEntry>(){

            @Override
            public Iterator<TarArchiveEntry> iterator() {
                return new TarArchiveEntryIterator(in);
            }
        };
        TarArchiveWalker walker = new TarArchiveWalker((ArchiveInputStream)in, parentId, request.getIdentifier().getAncestorId(), parentName);
        walker.walk(iterable);
    }

    void submit(TarArchiveEntry entry, String entryName, URI parentName, ArchiveInputStream in, long correlationId, long originatorNodeId) throws IOException {
        long size = entry.getSize();
        Date time = entry.getModTime();
        RequestMetaData metaData = new RequestMetaData(size == -1L ? null : Long.valueOf(size), time == null ? null : Long.valueOf(time.getTime()), entryName);
        RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toTarUri(parentName, entry.getName()));
        identifier.setAncestorId(originatorNodeId);
        identifier.setParentId(correlationId);
        IdentificationRequest request = this.factory.newRequest(metaData, identifier);
        request.open((InputStream)in);
        this.droidCore.submit(request);
    }

    public void setFactory(IdentificationRequestFactory factory) {
        this.factory = factory;
    }

    public void setDroidCore(AsynchDroid droidCore) {
        this.droidCore = droidCore;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    private final class TarArchiveWalker
    extends ArchiveFileWalker<TarArchiveEntry> {
        private long parentId;
        private long originatorNodeId;
        private URI parentName;
        private ArchiveInputStream in;
        private Map<String, Long> directories = new HashMap<String, Long>();

        TarArchiveWalker(ArchiveInputStream in, long parentId, long originatorNodeId, URI parentName) {
            this.in = in;
            this.parentId = parentId;
            this.parentName = parentName;
            this.originatorNodeId = originatorNodeId;
        }

        @Override
        protected void handleEntry(TarArchiveEntry entry) throws IOException {
            String entryName = StringUtils.stripEnd((String)entry.getName(), (String)"\\/");
            String prefixPath = FilenameUtils.getPath((String)entryName);
            String name = FilenameUtils.getName((String)entryName);
            Long correlationId = this.directories.get(prefixPath);
            if (correlationId == null) {
                correlationId = this.parentId;
                name = entryName;
            }
            if (entry.isDirectory()) {
                IdentificationResultImpl result = new IdentificationResultImpl();
                RequestMetaData metaData = new RequestMetaData(null, null, entryName);
                RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toTarUri(this.parentName, entry.getName()));
                identifier.setParentId(correlationId);
                identifier.setAncestorId(this.originatorNodeId);
                result.setRequestMetaData(metaData);
                result.setIdentifier(identifier);
                long dirId = TarArchiveHandler.this.resultHandler.handleDirectory(result, correlationId, false);
                this.directories.put(entry.getName(), dirId);
            } else {
                TarArchiveHandler.this.submit(entry, name, this.parentName, this.in, correlationId, this.originatorNodeId);
            }
        }
    }

    private static final class TarArchiveEntryIterator
    extends ArchiveInputStreamIterator<TarArchiveEntry, TarArchiveInputStream> {
        TarArchiveEntryIterator(TarArchiveInputStream in) {
            super(in);
        }

        @Override
        protected TarArchiveEntry getNextEntry(TarArchiveInputStream stream) throws IOException {
            return ((TarArchiveInputStream)this.getInputStream()).getNextTarEntry();
        }
    }
}

