/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileWalker;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveInputStreamIterator;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class ZipArchiveHandler
implements ArchiveHandler {
    private AsynchDroid droidCore;
    private IdentificationRequestFactory factory;
    private ResultHandler resultHandler;

    @Override
    public void handle(IdentificationRequest request) throws IOException {
        InputStream in = request.getSourceInputStream();
        final ZipArchiveInputStream zin = new ZipArchiveInputStream(in);
        Iterable<ZipArchiveEntry> iterable = new Iterable<ZipArchiveEntry>(){

            @Override
            public Iterator<ZipArchiveEntry> iterator() {
                return new ZipInputStreamInterator(zin);
            }
        };
        ZipArchiveWalker walker = new ZipArchiveWalker(zin, request.getIdentifier());
        walker.walk(iterable);
    }

    private long submitDirectory(URI parentName, ZipArchiveEntry entry, String entryName, Long correlationId) {
        IdentificationResultImpl result = new IdentificationResultImpl();
        long size = entry.getSize();
        long time = entry.getTime();
        RequestMetaData metaData = new RequestMetaData(size != -1L ? Long.valueOf(size) : null, time != -1L ? Long.valueOf(time) : null, entryName);
        RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toZipUri(parentName, entry.getName()));
        result.setRequestMetaData(metaData);
        result.setIdentifier(identifier);
        long dirId = this.resultHandler.handleDirectory(result, correlationId, false);
        return dirId;
    }

    void submit(ZipArchiveEntry entry, String entryName, URI parentName, ZipArchiveInputStream in, long correlationId, long originatorNodeId) throws IOException {
        long size = entry.getSize();
        long time = entry.getTime();
        RequestMetaData metaData = new RequestMetaData(size != -1L ? Long.valueOf(size) : null, time != -1L ? Long.valueOf(time) : null, entryName);
        RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toZipUri(parentName, entry.getName()));
        identifier.setAncestorId(originatorNodeId);
        identifier.setParentId(correlationId);
        IdentificationRequest request = this.factory.newRequest(metaData, identifier);
        request.open((InputStream)in);
        this.droidCore.submit(request);
    }

    public void setFactory(IdentificationRequestFactory factory) {
        this.factory = factory;
    }

    public void setDroidCore(AsynchDroid droidCore) {
        this.droidCore = droidCore;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    private final class ZipArchiveWalker
    extends ArchiveFileWalker<ZipArchiveEntry> {
        private long parentId;
        private long originatorNodeId;
        private URI parentName;
        private ZipArchiveInputStream in;
        private final Map<String, Long> directories = new HashMap<String, Long>();

        ZipArchiveWalker(ZipArchiveInputStream in, RequestIdentifier identifier) {
            this.in = in;
            this.parentId = identifier.getNodeId();
            this.parentName = identifier.getUri();
            this.originatorNodeId = identifier.getAncestorId();
        }

        @Override
        protected void handleEntry(ZipArchiveEntry entry) throws IOException {
            String name;
            String entryName = StringUtils.stripEnd((String)entry.getName(), (String)"\\/");
            String prefixPath = FilenameUtils.getPath((String)entryName);
            Long correlationId = this.directories.get(prefixPath);
            if (correlationId == null) {
                correlationId = this.parentId;
                name = entryName;
            } else {
                name = FilenameUtils.getName((String)entryName);
            }
            if (entry.isDirectory()) {
                long dirId = ZipArchiveHandler.this.submitDirectory(this.parentName, entry, name, correlationId);
                this.directories.put(entry.getName(), dirId);
            } else {
                ZipArchiveHandler.this.submit(entry, name, this.parentName, this.in, correlationId, this.originatorNodeId);
            }
        }
    }

    private static final class ZipInputStreamInterator
    extends ArchiveInputStreamIterator<ZipArchiveEntry, ZipArchiveInputStream> {
        public ZipInputStreamInterator(ZipArchiveInputStream in) {
            super(in);
        }

        @Override
        protected ZipArchiveEntry getNextEntry(ZipArchiveInputStream stream) throws IOException {
            return ((ZipArchiveInputStream)this.getInputStream()).getNextZipEntry();
        }
    }
}

