/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.filter.expressions;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Conjunction;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Criterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Disjunction;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Junction;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;

public final class Restrictions {
    private static final String PERIOD = ".";
    private static final char SPACE = ' ';

    private Restrictions() {
    }

    public static Criterion eq(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, "=");
    }

    public static Criterion neq(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, "!=");
    }

    public static Criterion gt(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, ">");
    }

    public static Criterion lt(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, "<");
    }

    public static Criterion gte(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, ">=");
    }

    public static Criterion lte(String propertyName, Object value) {
        return new SimpleExpression(propertyName, value, "<=");
    }

    public static Criterion like(String propertyName, String value) {
        return new SimpleExpression(propertyName, value, "LIKE");
    }

    public static Criterion in(String propertyName, Object[] values) {
        return new InExpression(propertyName, values, false);
    }

    public static Criterion notIn(String propertyName, Object[] values) {
        return new InExpression(propertyName, values, true);
    }

    public static Criterion or(Criterion lhs, Criterion rhs) {
        return new LogicalExpression(lhs, rhs, "OR");
    }

    public static Criterion and(Criterion lhs, Criterion rhs) {
        return new LogicalExpression(lhs, rhs, "AND");
    }

    private static String getAliasedQualifier(String propertyName, QueryBuilder parent) {
        if (propertyName.indexOf(46) > 0) {
            String root = StringUtils.substringBefore((String)propertyName, (String)PERIOD);
            String name = StringUtils.substringAfter((String)propertyName, (String)PERIOD);
            if (parent.getAliases().contains(root)) {
                return root + '.' + name;
            }
        }
        return parent.getAlias() + '.' + propertyName;
    }

    public static Junction conjunction() {
        return new Conjunction();
    }

    public static Junction disjunction() {
        return new Disjunction();
    }

    private static final class LogicalExpression
    implements Criterion {
        private Criterion lhs;
        private Criterion rhs;
        private String op;

        LogicalExpression(Criterion lhs, Criterion rhs, String op) {
            this.lhs = lhs;
            this.rhs = rhs;
            this.op = op;
        }

        @Override
        public Object[] getValues() {
            return ArrayUtils.addAll((Object[])this.lhs.getValues(), (Object[])this.rhs.getValues());
        }

        @Override
        public String toEjbQl(QueryBuilder parent) {
            return '(' + this.lhs.toEjbQl(parent) + ' ' + this.op + ' ' + this.rhs.toEjbQl(parent) + ')';
        }
    }

    private static final class InExpression
    implements Criterion {
        private String propertyName;
        private Object[] values;
        private boolean inverse;

        public InExpression(String propertyName, Object[] values, boolean inverse) {
            this.propertyName = propertyName;
            this.values = values;
            this.inverse = inverse;
        }

        @Override
        public Object[] getValues() {
            return this.values;
        }

        @Override
        public String toEjbQl(QueryBuilder parent) {
            return Restrictions.getAliasedQualifier(this.propertyName, parent) + (this.inverse ? " NOT " : Character.valueOf(' ')) + "IN (" + InExpression.repeat("?, ", this.values.length - 1) + "?)";
        }

        private static String repeat(String string, int times) {
            StringBuilder buf = new StringBuilder(string.length() * times);
            for (int i = 0; i < times; ++i) {
                buf.append(string);
            }
            return buf.toString();
        }

        public String toString() {
            return this.propertyName + " IN (" + this.values + ')';
        }
    }

    private static final class SimpleExpression
    implements Criterion {
        private String op;
        private String propertyName;
        private Object[] values;

        SimpleExpression(String propertyName, Object value, String op) {
            this.propertyName = propertyName;
            this.values = new Object[]{value};
            this.op = op;
        }

        @Override
        public String toEjbQl(QueryBuilder parent) {
            return Restrictions.getAliasedQualifier(this.propertyName, parent) + ' ' + this.op + " ?";
        }

        @Override
        public Object[] getValues() {
            return this.values;
        }

        public String toString() {
            return this.propertyName + this.op + this.values;
        }
    }
}

