/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import org.apache.commons.io.FilenameUtils;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedBinary;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class FileSystemIdentificationRequest
implements IdentificationRequest {
    private static final String ERROR_MESSAGE = "No byte at position [%s]";
    private static final int BUFFER_CACHE_CAPACITY = 10;
    private static final int CAPACITY = 51200;
    private String extension;
    private String fileName;
    private long size;
    private CachedBinary cachedBinary;
    private RequestIdentifier identifier;
    private int lruCapacity;
    private int bufferCapacity;
    private RequestMetaData requestMetaData;

    FileSystemIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier, int lruCapacity, int bufferCapacity) {
        this.identifier = identifier;
        this.requestMetaData = metaData;
        this.size = metaData.getSize();
        this.fileName = metaData.getName();
        this.extension = FilenameUtils.getExtension((String)this.fileName);
        this.lruCapacity = lruCapacity;
        this.bufferCapacity = bufferCapacity;
    }

    public FileSystemIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier) {
        this(metaData, identifier, 10, 51200);
    }

    @Override
    public void open(InputStream in) throws IOException {
        FileChannel channel = (FileChannel)Channels.newChannel(in);
        ByteBuffer blockZero = ByteBuffer.allocate(this.bufferCapacity);
        int bytesRead = 0;
        while ((bytesRead = channel.read(blockZero)) >= 0 && blockZero.hasRemaining()) {
        }
        this.cachedBinary = new CachedBinary(this.lruCapacity, this.bufferCapacity, blockZero);
        if (blockZero.limit() == blockZero.capacity()) {
            this.cachedBinary.setRaf(new RandomAccessFile(new File(this.identifier.getUri()), "r"));
        }
    }

    @Override
    public byte getByte(long position) {
        if (this.size <= position) {
            throw new IndexOutOfBoundsException(String.format(ERROR_MESSAGE, position));
        }
        return this.cachedBinary.getByte(position);
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        this.cachedBinary.close();
    }

    CachedBinary getCache() {
        return this.cachedBinary;
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        return this.cachedBinary.getSourceInputStream();
    }

    @Override
    public RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    @Override
    public RequestIdentifier getIdentifier() {
        return this.identifier;
    }
}

