/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.io.FilenameUtils;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedBinary;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class GZipIdentificationRequest
implements IdentificationRequest {
    private static final String ERROR_MESSAGE = "No byte at position [%s]";
    private static final int BUFFER_CACHE_CAPACITY = 10;
    private static final int CAPACITY = 51200;
    private String extension;
    private String fileName;
    private long size;
    private CachedBinary cachedBinary;
    private File tempFile;
    private int cacheCapacity;
    private int blockSize;
    private File tempDir;
    private RequestMetaData requestMetaData;
    private RequestIdentifier identifier;

    public GZipIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier, File tempDir) {
        this(metaData, identifier, 51200, 10, tempDir);
    }

    GZipIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier, int cacheCapacity, int blockSize, File tempDir) {
        this.identifier = identifier;
        String path = identifier.getUri().getSchemeSpecificPart();
        this.extension = FilenameUtils.getExtension((String)path);
        this.fileName = FilenameUtils.getName((String)path);
        this.cacheCapacity = cacheCapacity;
        this.blockSize = blockSize;
        this.tempDir = tempDir;
        this.requestMetaData = metaData;
    }

    @Override
    public void open(InputStream in) throws IOException {
        ReadableByteChannel channel = Channels.newChannel(in);
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.blockSize);
        int bytesRead = 0;
        while ((bytesRead = channel.read(buffer)) >= 0 && buffer.hasRemaining()) {
        }
        this.cachedBinary = new CachedBinary(this.cacheCapacity, this.blockSize, buffer);
        if (buffer.limit() == buffer.capacity()) {
            this.tempFile = ArchiveFileUtils.writeEntryToTemp(this.tempDir, buffer, channel);
            RandomAccessFile raf = new RandomAccessFile(this.tempFile, "r");
            this.cachedBinary.setRaf(raf);
            this.size = raf.length();
        } else {
            this.size = buffer.limit();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cachedBinary != null) {
            this.cachedBinary.close();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    @Override
    public byte getByte(long position) {
        if (this.size <= position) {
            throw new IndexOutOfBoundsException(String.format(ERROR_MESSAGE, position));
        }
        return this.cachedBinary.getByte(position);
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long size() {
        return this.size;
    }

    CachedBinary getCache() {
        return this.cachedBinary;
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        return this.cachedBinary.getSourceInputStream();
    }

    File getTempFile() {
        return this.tempFile;
    }

    @Override
    public RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    @Override
    public RequestIdentifier getIdentifier() {
        return this.identifier;
    }
}

