/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.io.FilenameUtils;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedBinary;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class ZipEntryIdentificationRequest
implements IdentificationRequest {
    private static final String ERROR_MESSAGE = "No byte at position [%s]";
    private static final int BUFFER_CACHE_CAPACITY = 10;
    private static final int CAPACITY = 51200;
    private Long size;
    private String extension;
    private CachedBinary binaryCache;
    private String fileName;
    private File tempFile;
    private int lruCapacity;
    private int bufferCapacity;
    private File tempDir;
    private RequestMetaData requestMetaData;
    private RequestIdentifier identifier;

    public ZipEntryIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier, File tempDir) {
        this(metaData, identifier, 10, 51200, tempDir);
    }

    ZipEntryIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier, int lruCapacity, int bufferCapacity, File tempDir) {
        this.identifier = identifier;
        this.size = metaData.getSize();
        this.fileName = metaData.getName();
        this.extension = FilenameUtils.getExtension((String)this.fileName);
        this.lruCapacity = lruCapacity;
        this.bufferCapacity = bufferCapacity;
        this.tempDir = tempDir;
        this.requestMetaData = metaData;
    }

    @Override
    public void open(InputStream in) throws IOException {
        ReadableByteChannel channel = Channels.newChannel(in);
        ByteBuffer buffer = ByteBuffer.allocate(this.bufferCapacity);
        int bytesRead = 0;
        while ((bytesRead = channel.read(buffer)) >= 0 && buffer.hasRemaining()) {
        }
        this.binaryCache = new CachedBinary(this.lruCapacity, this.bufferCapacity, buffer);
        if (buffer.limit() == buffer.capacity()) {
            this.tempFile = ArchiveFileUtils.writeEntryToTemp(this.tempDir, buffer, channel);
            RandomAccessFile raf = new RandomAccessFile(this.tempFile, "r");
            this.binaryCache.setRaf(raf);
            this.size = raf.length();
        } else {
            this.size = buffer.limit();
        }
    }

    @Override
    public void close() throws IOException {
        this.binaryCache.close();
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    @Override
    public byte getByte(long position) {
        if (this.size <= position) {
            throw new IndexOutOfBoundsException(String.format(ERROR_MESSAGE, position));
        }
        return this.binaryCache.getByte(position);
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long size() {
        return this.size;
    }

    CachedBinary getCache() {
        return this.binaryCache;
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        return this.binaryCache.getSourceInputStream();
    }

    File getTempFile() {
        return this.tempFile;
    }

    @Override
    public RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    @Override
    public RequestIdentifier getIdentifier() {
        return this.identifier;
    }
}

