/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class MarkerChunk
extends Chunk {
    public MarkerChunk(AiffModule aiffModule, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(aiffModule, chunkHeader, dataInputStream);
    }

    public boolean readChunk(RepInfo repInfo) throws IOException {
        AiffModule aiffModule = (AiffModule)this._module;
        int n = aiffModule.readUnsignedShort(this._dstream);
        if (n == 0) {
            return true;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = aiffModule.readUnsignedShort(this._dstream);
            long l = aiffModule.readUnsignedInt(this._dstream);
            String string = aiffModule.readPascalString(this._dstream);
            Property[] propertyArray = new Property[]{new Property("ID", PropertyType.INTEGER, (Object)new Integer(n2)), new Property("Position", PropertyType.LONG, (Object)new Long(l)), new Property("Name", PropertyType.STRING, (Object)string)};
            arrayList.add(new Property("Marker", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray));
        }
        aiffModule.addAiffProperty(new Property("Markers", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }
}

