/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.CountedInputStream;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.zip.InflaterInputStream;

public class BinaryFilterBox
extends JP2Box {
    private static final int[] gzipuuid = new int[]{236, 52, 11, 4, 116, 197, 17, 212, 167, 41, 135, 158, 163, 84, 143, 14};
    private DataInputStream boxStream;
    private JP2Box _realParent;

    public BinaryFilterBox(RandomAccessFile randomAccessFile, JP2Box jP2Box) {
        super(randomAccessFile, jP2Box);
        this._realParent = jP2Box;
    }

    public boolean readBox() throws IOException {
        int n;
        byte[] byArray = new byte[16];
        ModuleBase.readByteBuf((DataInputStream)this._dstrm, (byte[])byArray, (ModuleBase)this._module);
        boolean bl = true;
        for (n = 0; n < 16; ++n) {
            if (byArray[n] == gzipuuid[n]) continue;
            bl = false;
        }
        this._module.addBinaryFilterProp(new Property("BinaryFilter", PropertyType.BYTE, PropertyArity.ARRAY, (Object)byArray));
        if (bl) {
            this._repInfo.setMessage((Message)new InfoMessage("Binary Filter Box of type other than Gzip, contents not processed", this._module.getFilePos()));
        } else {
            n = (int)(this._boxHeader.getLength() - 16L);
            this.boxStream = new DataInputStream(new InflaterInputStream((InputStream)new CountedInputStream((InputStream)this._dstrm, n)));
        }
        return true;
    }

    public Object next() {
        BoxHeader boxHeader = new BoxHeader(this._module, this.boxStream);
        try {
            boxHeader.readHeader();
            JP2Box jP2Box = JP2Box.boxMaker(boxHeader.getType(), this._realParent);
            jP2Box.setModule(this._module);
            jP2Box.setRepInfo(this._repInfo);
            jP2Box.setRandomAccessFile(this._raf);
            jP2Box.setDataInputStream(this.boxStream);
            return jP2Box;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public DataInputStream getBoxStream() {
        return this.boxStream;
    }

    protected String getSelfPropName() {
        return "Binary Filter Box";
    }
}

