/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.IOException;

public class CRGMarkerSegment
extends MarkerSegment {
    protected boolean process(int n) throws IOException {
        if (this._ccs.getCurTile() != null) {
            this._repInfo.setMessage((Message)new ErrorMessage("CRG header allowed only in main header of codestream"));
            return false;
        }
        int n2 = this._cs.getNumComponents();
        if (n2 * 4 != n) {
            this._repInfo.setMessage((Message)new ErrorMessage("CRG marker segment has incorrect length"));
        }
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this._module.readUnsignedShort(this._dstream);
            nArray2[i] = this._module.readUnsignedShort(this._dstream);
        }
        Property[] propertyArray = new Property[]{new Property("HorizontalOffsets", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray), new Property("VerticalOffsets", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray2)};
        this._cs.setCRGProperty(new Property("ComponentRegistration", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray));
        return true;
    }
}

