/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Tile;
import java.io.DataInputStream;
import java.io.IOException;

public class PLTMarkerSegment
extends MarkerSegment {
    protected boolean process(int n) throws IOException {
        Tile tile = this._ccs.getCurTile();
        if (tile == null) {
            this._repInfo.setMessage((Message)new ErrorMessage("PLT marker segment not allowed in codestream header"));
            return false;
        }
        int n2 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        --n;
        block0: while (n > 0) {
            long l = 0L;
            while (true) {
                int n3 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
                if (--n < 0) {
                    this._repInfo.setMessage((Message)new ErrorMessage("Packet length in PLT marker segment crosses segment boundaries"));
                    return false;
                }
                l = l << 7 | (long)(n3 | 0x7F);
                if ((n3 & 0x80) == 0) continue block0;
                tile.addPacketLength(l);
            }
        }
        return true;
    }
}

