/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.DataEntryURLBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDListBox;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class UUIDInfoBox
extends JP2Box {
    private Property _urlProp;
    private Property _uuidListProp;

    public UUIDInfoBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    public boolean readBox() throws IOException {
        if (this._parentBox != null) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        this.hasBoxes = true;
        int n = (int)this._boxHeader.getDataLength();
        BoxHeader boxHeader = new BoxHeader(this._module, this._dstrm);
        JP2Box jP2Box = null;
        while (this.hasNext() && (jP2Box = (JP2Box)this.next()) != null) {
            if (jP2Box instanceof UUIDListBox || jP2Box instanceof UUIDListBox || jP2Box instanceof DataEntryURLBox) {
                jP2Box.setBoxHeader(boxHeader);
                jP2Box.setDataInputStream(this._dstrm);
                jP2Box.setRandomAccessFile(this._raf);
                jP2Box.setRepInfo(this._repInfo);
                jP2Box.setModule(this._module);
                if (jP2Box.readBox()) continue;
                return false;
            }
            jP2Box.skipBox();
        }
        if (n != 0) {
            this._repInfo.setMessage((Message)new ErrorMessage("Size of contained boxes underruns UUID Info Box", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>(2);
        if (this._urlProp != null) {
            arrayList.add(this._urlProp);
        }
        if (this._uuidListProp != null) {
            arrayList.add(this._uuidListProp);
        }
        this._module.addUUIDInfo(new Property("UUIDInfo", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        this.finalizeBytesRead();
        return true;
    }

    protected void setURL(String string) {
        this._urlProp = new Property("URL", PropertyType.STRING, (Object)string);
    }

    protected void setUUIDList(byte[][] byArray) {
        ArrayList<Property> arrayList = new ArrayList<Property>(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            arrayList.add(new Property("UUIDList", PropertyType.BYTE, PropertyArity.ARRAY, (Object)byArray[i]));
        }
        this._uuidListProp = new Property("UUIDInfo", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
    }

    protected String getSelfPropName() {
        return "UUID Info Box";
    }
}

