/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.ArrayEnd;
import edu.harvard.hul.ois.jhove.module.pdf.ArrayStart;
import edu.harvard.hul.ois.jhove.module.pdf.Comment;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryEnd;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryStart;
import edu.harvard.hul.ois.jhove.module.pdf.Keyword;
import edu.harvard.hul.ois.jhove.module.pdf.Literal;
import edu.harvard.hul.ois.jhove.module.pdf.Name;
import edu.harvard.hul.ois.jhove.module.pdf.Numeric;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.State;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import edu.harvard.hul.ois.jhove.module.pdf.StringValuedToken;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Set;
import java.util.TreeSet;

public abstract class Tokenizer {
    public static char[] PDFDOCENCODING = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u02d8', '\u02c7', '\u02c6', '\u02d9', '\u02dd', '\u02db', '\u02da', '\u02dc', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u2022', '\u2020', '\u2021', '\u2026', '\u2003', '\u2002', '\u0192', '\u2044', '\u2039', '\u203a', '\u2212', '\u2030', '\u201e', '\u201c', '\u201d', '\u2018', '\u2019', '\u201a', '\u2122', '\ufb01', '\ufb02', '\u0141', '\u0152', '\u0160', '\u0178', '\u017d', '\u0131', '\u0142', '\u0153', '\u0161', '\u017e', '\u009f', '\u20ac', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ef', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int BS = 8;
    private static final int HT = 9;
    private static final int FORMFEED = 12;
    private static final int ESC = 27;
    private static final int POUND_SIGN = 35;
    private static final int PERCENT_SIGN = 37;
    private static final int OPEN_PARENTHESIS = 40;
    private static final int CLOSE_PARENTHESIS = 41;
    private static final int PLUS = 43;
    private static final int MINUS = 45;
    private static final int PERIOD = 46;
    private static final int SLASH = 47;
    private static final int LESS_THAN = 60;
    private static final int GREATER_THAN = 62;
    private static final int OPEN_BRACKET = 91;
    private static final int BACKSLASH = 92;
    private static final int CLOSE_BRACKET = 93;
    private static final int a = 97;
    private static final int d = 100;
    private static final int e = 101;
    private static final int m = 109;
    private static final int n = 110;
    private static final int r = 114;
    private static final int s = 115;
    private static final int t = 116;
    private static final int[] DELIMITER = new int[]{37, 40, 41, 47, 60, 62, 91, 93, 123, 125};
    private static final int[] WHITESPACE = new int[]{0, 9, 10, 12, 13, 32};
    protected RandomAccessFile _file;
    protected int _ch = 0;
    private boolean _lookAhead = false;
    private long _offset = 0L;
    private State _state = State.WHITESPACE;
    private String _wsString = "";
    private boolean _pdfACompliant = true;
    private boolean _encrypted;
    private Set _languageCodes = new TreeSet();
    private int _parenLevel;
    private boolean _scanMode = false;

    public Token getNext() throws IOException, PdfException {
        return this.getNext(0L);
    }

    public Token getNext(long l) throws IOException, PdfException {
        String string = "Lexical error";
        Token token = null;
        StringBuffer stringBuffer = null;
        this._state = State.WHITESPACE;
        this._wsString = "";
        boolean bl = false;
        double d = 0.0;
        long l2 = 0L;
        double d2 = 10.0;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        long l4 = this._offset;
        try {
            while (true) {
                if (l > 0L && this._offset - l4 > l) {
                    if (token != null && token instanceof StringValuedToken && stringBuffer != null) {
                        ((StringValuedToken)token).setValue(stringBuffer.toString());
                    } else {
                        token = null;
                    }
                    return token;
                }
                if (!this._lookAhead) {
                    this._ch = this.readChar();
                    if (this._ch < 0) {
                        this._state = State.WHITESPACE;
                        throw new PdfMalformedException("Unexpected EOF", this._offset);
                    }
                    ++this._offset;
                } else {
                    this._lookAhead = false;
                }
                if (this._state == State.WHITESPACE) {
                    if (Tokenizer.isWhitespace(this._ch)) {
                        this._wsString = this._wsString + (char)this._ch;
                        continue;
                    }
                    if (this._ch == 91) {
                        this._state = State.WHITESPACE;
                        this._wsString = "";
                        return new ArrayStart();
                    }
                    if (this._ch == 93) {
                        this._state = State.WHITESPACE;
                        this._wsString = "";
                        return new ArrayEnd();
                    }
                    if (this._ch == 37) {
                        this._state = State.COMMENT;
                        stringBuffer = new StringBuffer();
                        token = new Comment();
                        continue;
                    }
                    if (this._ch == 43 || this._ch == 45) {
                        this._state = State.NUMERIC;
                        l2 = 0L;
                        bl = this._ch == 45;
                        token = new Numeric();
                        continue;
                    }
                    if (this._ch == 46) {
                        this._state = State.FRACTIONAL;
                        d = 0.0;
                        bl = false;
                        d2 = 10.0;
                        token = new Numeric();
                        continue;
                    }
                    if (Tokenizer.isNumeral(this._ch)) {
                        this._state = State.NUMERIC;
                        l2 = this._ch - 48;
                        d2 = 10.0;
                        token = new Numeric();
                        continue;
                    }
                    if (this._ch == 47) {
                        this._state = State.NAME;
                        stringBuffer = new StringBuffer();
                        token = new Name();
                        continue;
                    }
                    if (this._ch == 40) {
                        if (this._scanMode) continue;
                        this._state = State.LITERAL;
                        this._parenLevel = 0;
                        token = new Literal();
                        stringBuffer = new StringBuffer();
                        continue;
                    }
                    if (this._ch == 60) {
                        this._state = State.LESS_THAN;
                        continue;
                    }
                    if (this._ch == 62) {
                        this._state = State.GREATER_THAN;
                        continue;
                    }
                    if (Tokenizer.isDelimiter(this._ch)) continue;
                    this._state = State.KEYWORD;
                    stringBuffer = new StringBuffer();
                    stringBuffer.append((char)this._ch);
                    token = new Keyword();
                    continue;
                }
                if (this._state == State.COMMENT) {
                    if (this._ch == 13 || this._ch == 10) {
                        this._state = State.WHITESPACE;
                        this._wsString = this._wsString + (char)this._ch;
                        ((StringValuedToken)token).setValue(stringBuffer.toString());
                        return token;
                    }
                    stringBuffer.append((char)this._ch);
                    continue;
                }
                if (this._state == State.FRACTIONAL) {
                    if (Tokenizer.isDelimiter(this._ch) || Tokenizer.isWhitespace(this._ch)) {
                        this._state = State.WHITESPACE;
                        this._wsString = "" + (char)this._ch;
                        if (bl) {
                            d = -d;
                        }
                        ((Numeric)token).setValue(d);
                        if (Tokenizer.isDelimiter(this._ch)) {
                            this._lookAhead = true;
                        }
                        return token;
                    }
                    if (Tokenizer.isNumeral(this._ch)) {
                        d += (double)(this._ch - 48) / d2;
                        d2 *= 10.0;
                        continue;
                    }
                    this._state = State.WHITESPACE;
                    this._wsString = "";
                    throw new PdfMalformedException(string, this._offset);
                }
                if (this._state == State.GREATER_THAN) {
                    if (this._ch == 62) {
                        this._state = State.WHITESPACE;
                        this._wsString = "";
                        return new DictionaryEnd();
                    }
                    this._state = State.WHITESPACE;
                    this._wsString = "";
                    throw new PdfMalformedException(string, this._offset);
                }
                if (this._state == State.HEXADECIMAL) {
                    if (this._ch == 62) {
                        this._state = State.WHITESPACE;
                        this._wsString = "";
                        ((Literal)token).convertHex();
                        return token;
                    }
                    if (Tokenizer.isWhitespace(this._ch)) continue;
                    ((Literal)token).appendHex(this._ch);
                    continue;
                }
                if (this._state == State.KEYWORD) {
                    if (Tokenizer.isDelimiter(this._ch) || Tokenizer.isWhitespace(this._ch)) {
                        if (Tokenizer.isDelimiter(this._ch)) {
                            this._lookAhead = true;
                        }
                        if (stringBuffer.toString().equals("stream")) {
                            this._state = State.STREAM;
                            bl2 = this._ch == 10;
                            bl3 = this._ch == 13;
                            token = new Stream();
                            l3 = 0L;
                            n2 = 0;
                            n = 0;
                            this.initStream((Stream)token);
                            continue;
                        }
                        this._state = State.WHITESPACE;
                        this._wsString = "" + (char)this._ch;
                        ((StringValuedToken)token).setValue(stringBuffer.toString());
                        return token;
                    }
                    stringBuffer.append((char)this._ch);
                    continue;
                }
                if (this._state == State.LESS_THAN) {
                    if (this._ch == 60 || this._scanMode) {
                        this._state = State.WHITESPACE;
                        this._wsString = "";
                        return new DictionaryStart();
                    }
                    this._state = State.HEXADECIMAL;
                    token = new Literal();
                    stringBuffer = new StringBuffer();
                    ((Literal)token).appendHex(this._ch);
                    continue;
                }
                if (this._state == State.LITERAL) {
                    this.backupChar();
                    this._offset += ((Literal)token).processLiteral(this) - 1L;
                    this._state = State.WHITESPACE;
                    this._wsString = "";
                    return token;
                }
                if (this._state == State.NAME) {
                    if (this._ch == 35) {
                        int n3 = this.readChar();
                        int n4 = this.readChar();
                        this._ch = (Tokenizer.hexValue(n3) << 8) + Tokenizer.hexValue(n4);
                    }
                    if (Tokenizer.isDelimiter(this._ch) || Tokenizer.isWhitespace(this._ch)) {
                        this._state = State.WHITESPACE;
                        ((StringValuedToken)token).setValue(stringBuffer.toString());
                        if (Tokenizer.isDelimiter(this._ch)) {
                            this._lookAhead = true;
                            this._wsString = "";
                        } else {
                            this._wsString = "" + (char)this._ch;
                        }
                        return token;
                    }
                    stringBuffer.append((char)this._ch);
                    continue;
                }
                if (this._state == State.NUMERIC) {
                    if (this._ch == 46) {
                        this._state = State.FRACTIONAL;
                        d = l2;
                        d2 = 10.0;
                        continue;
                    }
                    if (Tokenizer.isDelimiter(this._ch) || Tokenizer.isWhitespace(this._ch) || !Tokenizer.isNumeral(this._ch)) {
                        if (bl) {
                            if (this._state == State.FRACTIONAL) {
                                d = -d;
                            } else {
                                l2 = -l2;
                            }
                        }
                        if (this._state == State.FRACTIONAL) {
                            ((Numeric)token).setValue(d);
                        } else {
                            ((Numeric)token).setValue(l2);
                        }
                        this._state = State.WHITESPACE;
                        if (Tokenizer.isDelimiter(this._ch)) {
                            this._lookAhead = true;
                            this._wsString = "";
                        } else {
                            this._wsString = "" + (char)this._ch;
                        }
                        return token;
                    }
                    if (this._state == State.FRACTIONAL) {
                        d = d * 10.0 + (double)this._ch - 48.0;
                        continue;
                    }
                    l2 = l2 * 10L + (long)this._ch - 48L;
                    continue;
                }
                if (this._state == State.STREAM) {
                    if (this._ch == 101) {
                        this._state = State.E;
                        continue;
                    }
                    n = n2;
                    n2 = this._ch;
                    this.setStreamOffset((Stream)token);
                    if (l3 == 0L && !bl2) {
                        if (this._ch == 10) {
                            bl2 = true;
                            if (!bl3) {
                                this._pdfACompliant = false;
                            }
                            ((Stream)token).setOffset(((Stream)token).getOffset() + 1L);
                            continue;
                        }
                        if (this._ch == 13) {
                            bl3 = true;
                            ((Stream)token).setOffset(((Stream)token).getOffset() + 1L);
                            continue;
                        }
                        this._pdfACompliant = false;
                        continue;
                    }
                    ++l3;
                    continue;
                }
                if (this._state == State.E) {
                    if (this._ch == 110) {
                        this._state = State.EN;
                        continue;
                    }
                    this._state = State.STREAM;
                    l3 += 2L;
                    continue;
                }
                if (this._state == State.EN) {
                    if (this._ch == 100) {
                        this._state = State.END;
                        continue;
                    }
                    this._state = State.STREAM;
                    l3 += 3L;
                    continue;
                }
                if (this._state == State.END) {
                    if (this._ch == 115) {
                        this._state = State.ENDS;
                        continue;
                    }
                    this._state = State.STREAM;
                    l3 += 4L;
                    continue;
                }
                if (this._state == State.ENDS) {
                    if (this._ch == 116) {
                        this._state = State.ENDST;
                        continue;
                    }
                    this._state = State.STREAM;
                    l3 += 5L;
                    continue;
                }
                if (this._state == State.ENDST) {
                    if (this._ch == 114) {
                        this._state = State.ENDSTR;
                        continue;
                    }
                    this._state = State.STREAM;
                    l3 += 6L;
                    continue;
                }
                if (this._state == State.ENDSTR) {
                    if (this._ch == 101) {
                        this._state = State.ENDSTRE;
                        continue;
                    }
                    this._state = State.STREAM;
                    l3 += 7L;
                    continue;
                }
                if (this._state == State.ENDSTRE) {
                    if (this._ch == 97) {
                        this._state = State.ENDSTREA;
                        continue;
                    }
                    this._state = State.STREAM;
                    l3 += 8L;
                    continue;
                }
                if (this._state == State.ENDSTREA) {
                    if (this._ch == 109) {
                        this._state = State.ENDSTREAM;
                        continue;
                    }
                    this._state = State.STREAM;
                    l3 += 9L;
                    continue;
                }
                if (this._state != State.ENDSTREAM) continue;
                if (Tokenizer.isDelimiter(this._ch) || Tokenizer.isWhitespace(this._ch)) {
                    this._state = State.WHITESPACE;
                    if (n == 13 && n2 == 10) {
                        l3 -= 2L;
                    } else if (n2 == 10 || n2 == 13) {
                        --l3;
                    }
                    ((Stream)token).setLength(l3);
                    if (Tokenizer.isDelimiter(this._ch)) {
                        this._lookAhead = true;
                        this._wsString = "";
                    } else {
                        this._wsString = "" + (char)this._ch;
                    }
                    return token;
                }
                this._state = State.STREAM;
            }
        }
        catch (EOFException eOFException) {
            if (token != null && token instanceof StringValuedToken && stringBuffer != null) {
                ((StringValuedToken)token).setValue(stringBuffer.toString());
            } else {
                token = null;
            }
            return token;
        }
    }

    public long getOffset() {
        return this._offset;
    }

    public Set getLanguageCodes() {
        return this._languageCodes;
    }

    public void setEncrypted(boolean bl) {
        this._encrypted = bl;
    }

    public boolean getPDFACompliant() {
        return this._pdfACompliant;
    }

    public void setPDFACompliant(boolean bl) {
        this._pdfACompliant = bl;
    }

    public String getWSString() {
        return this._wsString;
    }

    public abstract void seek(long var1) throws IOException, PdfException;

    protected void seekReset(long l) {
        this._state = State.WHITESPACE;
        this._wsString = "";
        this._lookAhead = false;
        this._ch = 0;
        this._offset = l - 1L;
    }

    public abstract int readChar() throws IOException;

    public int readChar1(boolean bl) throws IOException {
        if (bl) {
            int n = this.readChar();
            int n2 = this.readChar();
            return n << 8 | n2;
        }
        return this.readChar();
    }

    public abstract void backupChar();

    public void addLanguageCode(String string) {
        this._languageCodes.add(string);
    }

    private static int hexValue(int n) throws PdfException {
        int n2 = 0;
        if (48 <= n && n <= 57) {
            n2 = n - 48;
        } else if (65 <= n && n <= 70) {
            n2 = n - 55;
        } else if (97 <= n && n <= 102) {
            n2 = n - 87;
        } else {
            throw new PdfMalformedException("Invalid character in hex string", 0L);
        }
        return n2;
    }

    private static boolean isDelimiter(int n) {
        boolean bl = false;
        for (int i = 0; i < DELIMITER.length; ++i) {
            if (n != DELIMITER[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean isNumeral(int n) {
        return 48 <= n && n <= 57;
    }

    private static boolean isWhitespace(int n) {
        boolean bl = false;
        for (int i = 0; i < WHITESPACE.length; ++i) {
            if (n != WHITESPACE[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void scanMode(boolean bl) {
        this._scanMode = bl;
    }

    protected abstract void initStream(Stream var1) throws IOException, PdfException;

    protected abstract void setStreamOffset(Stream var1) throws IOException, PdfException;
}

