/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffFXBase;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;

public class TiffProfileFXL
extends TiffFXBase {
    public TiffProfileFXL() {
        this._profileText = "TIFF-FX (Profile L)";
        this._mimeClass = 1;
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (!this.satisfiesClass(tiffIFD)) {
            return false;
        }
        if (!this.satisfiesImageWidth(tiffIFD, new int[]{864, 1024, 1216, 1728, 2048, 2432, 2592, 3072, 3456, 3648, 4096, 4864})) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, 10)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, new int[]{2, 5, 10})) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3, -1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, new int[]{1, 3, 4})) {
            return false;
        }
        if (!this.satisfiesXResolution(tiffIFD, new int[]{100, 200, 300, 400})) {
            return false;
        }
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        if (nisoImageMetadata.getXSamplingFrequency().toLong() != nisoImageMetadata.getYSamplingFrequency().toLong()) {
            return false;
        }
        if (!this.satisfiesIndexed(tiffIFD, new int[]{0, 1})) {
            return false;
        }
        if (!this.satisfiesFillOrder(tiffIFD, new int[]{1, 2})) {
            return false;
        }
        int n = nisoImageMetadata.getBitsPerSample()[0];
        if (n > 16) {
            return false;
        }
        return tiffIFD.getIndexed() != 1 || nisoImageMetadata.getColormapRedValue() != null;
    }
}

