/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfileRFC1314
extends TiffProfile {
    public TiffProfileRFC1314() {
        this._profileText = "RFC 1314";
        this._mimeClass = 2;
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        if (nisoImageMetadata.getImageWidth() != -1L || nisoImageMetadata.getImageLength() != -1L || tiffIFD.getNewSubfileType() != -1L || nisoImageMetadata.getRowsPerStrip() == -1L || nisoImageMetadata.getStripByteCounts() == null || nisoImageMetadata.getStripOffsets() == null || nisoImageMetadata.getXSamplingFrequency() == null || nisoImageMetadata.getYSamplingFrequency() == null) {
            return false;
        }
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray == null || nArray[0] != 1) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, new int[]{1, 3, 4})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, new int[]{0, 1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, 1)) {
            return false;
        }
        return this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3});
    }
}

