/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ByteArrayXMPSource;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.LinkChunkHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LinkChunk
extends Chunk {
    public LinkChunk(ModuleBase moduleBase, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(moduleBase, chunkHeader, dataInputStream);
    }

    public boolean readChunk(RepInfo repInfo) throws IOException {
        WaveModule waveModule = (WaveModule)this._module;
        byte[] byArray = new byte[(int)this.bytesLeft];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)waveModule);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayXMPSource byteArrayXMPSource = new ByteArrayXMPSource(byteArrayInputStream);
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            LinkChunkHandler linkChunkHandler = new LinkChunkHandler();
            xMLReader.setContentHandler(linkChunkHandler);
            xMLReader.parse((InputSource)byteArrayXMPSource);
            List list = linkChunkHandler.getFileNames();
            String string = linkChunkHandler.getID();
            if (!list.isEmpty()) {
                ArrayList<Property> arrayList = new ArrayList<Property>(2);
                arrayList.add(new Property("FileNames", PropertyType.STRING, PropertyArity.LIST, (Object)list));
                if (string != null) {
                    arrayList.add(new Property("ID", PropertyType.STRING, (Object)string));
                }
                waveModule.addWaveProperty(new Property("Link", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
            }
        }
        catch (SAXException sAXException) {
            repInfo.setMessage((Message)new ErrorMessage("SAXException in reading Link Chunk"));
            repInfo.setValid(false);
            return true;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            repInfo.setMessage((Message)new ErrorMessage("ParserConfigurationException in reading Link Chunk"));
            repInfo.setValid(false);
            return true;
        }
        return true;
    }
}

