/*
 * Decompiled with CFR 0.152.
 */
package org.trippi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilderFactory;
import org.trippi.ConnectorParameter;
import org.trippi.TriplestoreConnector;
import org.trippi.TrippiException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorDescriptor {
    private String m_name;
    private String m_description;
    private List<ConnectorParameter> m_parameters = new ArrayList<ConnectorParameter>();

    public static ConnectorDescriptor forName(String className) throws TrippiException {
        String path = className.replaceAll("\\.", "/") + "Descriptor.xml";
        InputStream xml = ClassLoader.getSystemClassLoader().getResourceAsStream(path);
        if (xml != null) {
            return new ConnectorDescriptor(xml);
        }
        throw new TrippiException("Not found in classpath: " + path);
    }

    public static Map<String, ConnectorDescriptor> find() throws TrippiException, IOException {
        HashMap<String, ConnectorDescriptor> m = new HashMap<String, ConnectorDescriptor>();
        File jarDir = new File(System.getProperty("java.endorsed.dirs"));
        String[] jarNames = jarDir.list();
        for (int i = 0; i < jarNames.length; ++i) {
            if (!jarNames[i].toLowerCase().endsWith(".jar")) continue;
            JarFile f = new JarFile(new File(jarDir, jarNames[i]));
            Enumeration<JarEntry> e = f.entries();
            while (e.hasMoreElements()) {
                String c;
                JarEntry entry = e.nextElement();
                if (!entry.getName().endsWith("Descriptor.xml") || f.getJarEntry((c = entry.getName().replaceAll("Descriptor.xml", "")) + ".class") == null) continue;
                String className = c.replaceAll("/", ".");
                m.put(className, TriplestoreConnector.getDescriptor(className));
            }
        }
        return m;
    }

    public ConnectorDescriptor(InputStream in) throws TrippiException {
        try {
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in).getDocumentElement();
            this.m_name = root.getAttribute("name");
            this.m_description = this.getDescription(root);
            this.m_parameters = this.getParameters(root);
        }
        catch (Exception e) {
            throw new TrippiException("Unexpected error in descriptor.xml", e);
        }
        if (this.m_name == null || this.m_name.equals("")) {
            throw new TrippiException("Bad descriptor.xml: name attribute required on root element.");
        }
    }

    private String getDescription(Element parent) throws Exception {
        NodeList d = parent.getChildNodes();
        for (int i = 0; i < d.getLength(); ++i) {
            String val;
            Node n = d.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals("description") || (val = n.getFirstChild().getNodeValue()) == null) continue;
            return val.trim().replaceAll("\n", " ").replaceAll(" +", " ");
        }
        return null;
    }

    private List<ConnectorParameter> getParameters(Element parent) throws Exception {
        NodeList d = parent.getChildNodes();
        ArrayList<ConnectorParameter> paramList = new ArrayList<ConnectorParameter>();
        for (int i = 0; i < d.getLength(); ++i) {
            Node n = d.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals("parameter")) continue;
            paramList.add(this.getParameter((Element)n));
        }
        return paramList;
    }

    private ConnectorParameter getParameter(Element param) throws Exception {
        String name = param.getAttribute("name");
        String label = param.getAttribute("label");
        String optional = param.getAttribute("optional");
        boolean isOptional = true;
        if (optional == null || optional == "" || optional.equalsIgnoreCase("false") || optional.equalsIgnoreCase("no")) {
            isOptional = false;
        }
        String description = this.getDescription(param);
        HashMap<String, List<ConnectorParameter>> paramsMap = new HashMap<String, List<ConnectorParameter>>();
        ArrayList<String> options = new ArrayList<String>();
        NodeList d = param.getChildNodes();
        for (int i = 0; i < d.getLength(); ++i) {
            Node n = d.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals("option")) continue;
            Element option = (Element)n;
            String optionValue = option.getAttribute("value");
            List<ConnectorParameter> optionParameters = this.getParameters(option);
            options.add(optionValue);
            paramsMap.put(optionValue, optionParameters);
        }
        return new ConnectorParameter(name, label, description, isOptional, options, paramsMap);
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public List<ConnectorParameter> getParameters() {
        return this.m_parameters;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Connector name : " + this.m_name + "\n");
        out.append("   Description : " + this.m_description + "\n");
        for (ConnectorParameter param : this.m_parameters) {
            out.append(param.toString(0));
        }
        return out.toString();
    }

    public static void main(String[] args) throws Exception {
        ConnectorDescriptor d = new ConnectorDescriptor(new FileInputStream(new File(args[0])));
        System.out.println(d.toString());
    }
}

