/*
 * Decompiled with CFR 0.152.
 */
package org.trippi;

import org.trippi.TrippiException;

public class RDFFormat {
    public static final RDFFormat N_TRIPLES = new RDFFormat("N-Triples", "US-ASCII", "text/plain", ".nt");
    public static final RDFFormat NOTATION_3 = new RDFFormat("Notation 3", "UTF-8", "text/rdf+n3", ".n3");
    public static final RDFFormat RDF_XML = new RDFFormat("RDF/XML", "UTF-8", "application/rdf+xml", ".xml");
    public static final RDFFormat TURTLE = new RDFFormat("Turtle", "UTF-8", "application/x-turtle", ".ttl");
    public static final RDFFormat CSV = new RDFFormat("CSV", "UTF-8", "text/plain", ".csv");
    public static final RDFFormat SPARQL = new RDFFormat("Sparql", "UTF-8", "application/xml", ".xml");
    public static final RDFFormat SIMPLE = new RDFFormat("Simple", "UTF-8", "text/plain", ".txt");
    public static final RDFFormat TSV = new RDFFormat("TSV", "UTF-8", "text/plain", ".tsv");
    public static final RDFFormat COUNT = new RDFFormat("count", "UTF-8", "text/plain", ".txt");
    public static final RDFFormat[] ALL = new RDFFormat[]{N_TRIPLES, NOTATION_3, RDF_XML, TURTLE, CSV, SIMPLE, SPARQL, TSV, COUNT};
    private String m_name;
    private String m_encoding;
    private String m_mediaType;
    private String m_extension;

    private RDFFormat(String name, String encoding, String mediaType, String extension) {
        this.m_name = name;
        this.m_encoding = encoding;
        this.m_mediaType = mediaType;
        this.m_extension = extension;
    }

    public String getName() {
        return this.m_name;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public String getMediaType() {
        return this.m_mediaType;
    }

    public String getExtension() {
        return this.m_extension;
    }

    public static RDFFormat forName(String name) throws TrippiException {
        String s = RDFFormat.simplifyName(name);
        for (int i = 0; i < ALL.length; ++i) {
            if (!s.equals(RDFFormat.simplifyName(ALL[i].getName()))) continue;
            return ALL[i];
        }
        throw new TrippiException("Unrecognized format: " + name);
    }

    private static final String simplifyName(String name) {
        if ((name = name.toLowerCase().trim().replaceAll(" ", "").replaceAll("-", "").replaceAll("/", "").replaceAll("-", "")).equals("nt")) {
            return "ntriples";
        }
        if (name.equals("n3")) {
            return "notation3";
        }
        if (name.equals("ttl")) {
            return "turtle";
        }
        if (name.equals("rdf")) {
            return "rdfxml";
        }
        return name;
    }
}

