/*
 * Decompiled with CFR 0.152.
 */
package org.trippi;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.GraphElementFactoryException;
import org.jrdf.graph.Node;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.trippi.RDFUtil;
import org.trippi.TrippiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriplePattern {
    private Object m_subject;
    private Object m_predicate;
    private Object m_object;

    public TriplePattern(Object subject, Object predicate, Object object) throws TrippiException {
        if (!(subject instanceof String) && !(subject instanceof SubjectNode)) {
            throw new TrippiException("Error in triple pattern: subject must be a String or a SubjectNode (not " + subject.getClass().getName() + ")");
        }
        if (!(predicate instanceof String) && !(predicate instanceof PredicateNode)) {
            throw new TrippiException("Error in triple pattern: predicate must be a String or a PredicateNode (not " + predicate.getClass().getName() + ")");
        }
        if (!(object instanceof String) && !(object instanceof ObjectNode)) {
            throw new TrippiException("Error in triple pattern: object must be a String or an ObjectNode (not " + object.getClass().getName() + ")");
        }
        this.m_subject = subject;
        this.m_predicate = predicate;
        this.m_object = object;
    }

    public static TriplePattern[] parse(String patterns) throws TrippiException {
        try {
            List<String> tokens = TriplePattern.tokenize(patterns.replaceAll("\r", " "));
            if (tokens.size() % 3 != 0 || tokens.size() == 0) {
                throw new TrippiException("Triple pattern token count not divisible by 3.");
            }
            TriplePattern[] out = new TriplePattern[tokens.size() / 3];
            Iterator<String> iter = tokens.iterator();
            int i = 0;
            RDFUtil factory = new RDFUtil();
            while (iter.hasNext()) {
                Object subject = TriplePattern.parseToken(iter.next(), factory);
                Object predicate = TriplePattern.parseToken(iter.next(), factory);
                Object object = TriplePattern.parseToken(iter.next(), factory);
                out[i++] = new TriplePattern(subject, predicate, object);
            }
            return out;
        }
        catch (Exception e) {
            String msg = "Parse error: " + e.getClass().getName();
            if (e.getMessage() != null) {
                msg = msg + ": " + e.getMessage();
            }
            throw new TrippiException(msg, e);
        }
    }

    public static List<Triple> parse(String triples, GraphElementFactory factory) throws TrippiException {
        try {
            TriplePattern[] patterns = TriplePattern.parse(triples);
            HashMap<String, BlankNode> bNodes = new HashMap<String, BlankNode>();
            ArrayList<Triple> list = new ArrayList<Triple>();
            for (int i = 0; i < patterns.length; ++i) {
                ObjectNode object;
                SubjectNode subject;
                BlankNode b;
                Object s = patterns[i].getSubject();
                Object p = patterns[i].getPredicate();
                Object o = patterns[i].getObject();
                if (s instanceof String) {
                    b = (BlankNode)bNodes.get(s);
                    if (b == null) {
                        b = factory.createResource();
                        bNodes.put((String)s, b);
                    }
                    subject = b;
                } else {
                    subject = (SubjectNode)s;
                }
                if (p instanceof String) {
                    throw new TrippiException("Predicate cannot be bNode.");
                }
                PredicateNode predicate = (PredicateNode)p;
                if (o instanceof String) {
                    b = (BlankNode)bNodes.get(o);
                    if (b == null) {
                        b = factory.createResource();
                        bNodes.put((String)o, b);
                    }
                    object = b;
                } else {
                    object = (ObjectNode)o;
                }
                list.add(factory.createTriple(subject, predicate, object));
            }
            return list;
        }
        catch (Exception e) {
            throw new TrippiException("Error creating triples from string.", e);
        }
    }

    private static Object parseToken(String token, RDFUtil factory) throws GraphElementFactoryException, URISyntaxException {
        char c = token.charAt(0);
        if (c == '\'' || c == '\"' || c == '<' || c == '_') {
            return factory.parse(token);
        }
        if (c == '$' || c == '?') {
            return token.substring(1);
        }
        return token;
    }

    private static List<String> tokenize(String patterns) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean inToken = false;
        boolean inLiteral = false;
        boolean lastWasEscape = false;
        boolean inQuotedPart = false;
        char qChar = ' ';
        StringBuffer token = null;
        for (int i = 0; i < patterns.length(); ++i) {
            char c = patterns.charAt(i);
            if (inToken) {
                if (inLiteral) {
                    if (inQuotedPart) {
                        if (lastWasEscape) {
                            lastWasEscape = false;
                            token.append(c);
                        } else if (c == qChar) {
                            char n;
                            token.append(c);
                            inQuotedPart = false;
                            if (i + 1 < patterns.length() && ((n = patterns.charAt(i + 1)) == '\n' || n == '\t' || n == ' ' || n == ',' || n == '(' || n == ')')) {
                                inToken = false;
                                inLiteral = false;
                                tokens.add(token.toString());
                            }
                        } else {
                            if (c == '\\') {
                                lastWasEscape = true;
                            }
                            token.append(c);
                        }
                    } else if (c == '\n' || c == '\t' || c == ' ' || c == ',' || c == '(' || c == ')') {
                        inToken = false;
                        inLiteral = false;
                        tokens.add(token.toString());
                    } else {
                        token.append(c);
                    }
                } else if (c == '\n' || c == '\t' || c == ' ' || c == ',' || c == '(' || c == ')') {
                    inToken = false;
                    tokens.add(token.toString());
                } else {
                    token.append(c);
                }
            } else if (c != '\n' && c != '\t' && c != ' ' && c != ',' && c != '(' && c != ')') {
                inToken = true;
                if (c == '\"' || c == '\'') {
                    inLiteral = true;
                    inQuotedPart = true;
                    lastWasEscape = false;
                    qChar = c;
                }
                token = new StringBuffer();
                token.append(c);
            }
            if (inToken) continue;
            token = null;
        }
        if (token != null) {
            tokens.add(token.toString());
        }
        return tokens;
    }

    public Object getSubject() {
        return this.m_subject;
    }

    public Object getPredicate() {
        return this.m_predicate;
    }

    public Object getObject() {
        return this.m_object;
    }

    public Triple match(Map<String, Node> tuple) throws TrippiException {
        try {
            Object object;
            PredicateNode predicate;
            Object subject;
            Node n;
            RDFUtil factory = new RDFUtil();
            if (this.m_subject instanceof String) {
                n = this.getMatchingNode((String)this.m_subject, tuple, 0);
                if (n == null) {
                    return null;
                }
                subject = (SubjectNode)n;
            } else {
                subject = this.m_subject instanceof BlankNode ? factory.createResource(((Object)tuple).hashCode() + this.m_subject.hashCode()) : (SubjectNode)this.m_subject;
            }
            if (this.m_predicate instanceof String) {
                n = this.getMatchingNode((String)this.m_predicate, tuple, 1);
                if (n == null) {
                    return null;
                }
                predicate = (PredicateNode)n;
            } else {
                predicate = (PredicateNode)this.m_predicate;
            }
            if (this.m_object instanceof String) {
                n = this.getMatchingNode((String)this.m_object, tuple, 2);
                if (n == null) {
                    return null;
                }
                object = (ObjectNode)n;
            } else {
                object = this.m_object instanceof BlankNode ? factory.createResource(((Object)tuple).hashCode() + this.m_object.hashCode()) : (ObjectNode)this.m_object;
            }
            return factory.createTriple((SubjectNode)subject, predicate, (ObjectNode)object);
        }
        catch (Exception e) {
            String msg = e.getClass().getName();
            if (e.getMessage() != null) {
                msg = msg + ": " + e.getMessage();
            }
            throw new TrippiException(msg, e);
        }
    }

    private Node getMatchingNode(String key, Map<String, Node> tuple, int type) throws TrippiException {
        if (tuple.containsKey(key)) {
            Node node = tuple.get(key);
            if (node == null) {
                return null;
            }
            if (type == 0) {
                if (node instanceof SubjectNode) {
                    return node;
                }
                return null;
            }
            if (type == 1) {
                if (node instanceof PredicateNode) {
                    return node;
                }
                return null;
            }
            if (node instanceof ObjectNode) {
                return node;
            }
            return null;
        }
        throw new TrippiException("No value named '" + key + "' in tuple.");
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        if (this.m_subject instanceof String) {
            out.append(this.m_subject + " ");
        } else {
            out.append(RDFUtil.toString((Node)this.m_subject) + " ");
        }
        if (this.m_predicate instanceof String) {
            out.append(this.m_predicate + " ");
        } else {
            out.append(RDFUtil.toString((Node)this.m_predicate) + " ");
        }
        if (this.m_object instanceof String) {
            out.append(this.m_object);
        } else {
            out.append(RDFUtil.toString((Node)this.m_object));
        }
        return out.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.print("Patterns: ");
        TriplePattern[] patterns = TriplePattern.parse(new BufferedReader(new InputStreamReader(System.in)).readLine());
        for (int i = 0; i < patterns.length; ++i) {
            System.out.println("Pattern " + i + ":" + patterns[i].toString());
        }
    }
}

