/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import gnu.trove.TIntHashSet;
import java.util.Map;
import org.jrdf.graph.Node;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistinctTupleIterator
extends TupleIterator {
    private TupleIterator m_wrapped;
    private TIntHashSet m_seen;
    private Map<String, Node> m_next;
    private boolean m_closed = false;

    public DistinctTupleIterator(TupleIterator wrapped) throws TrippiException {
        this.m_wrapped = wrapped;
        this.m_seen = new TIntHashSet();
        this.m_next = this.getNext();
    }

    private Map<String, Node> getNext() throws TrippiException {
        while (this.m_wrapped.hasNext()) {
            Map<String, Node> nextMap = this.m_wrapped.next();
            if (this.seen(((Object)nextMap).hashCode())) continue;
            return nextMap;
        }
        return null;
    }

    private boolean seen(int id) {
        if (this.m_seen.contains(id)) {
            return true;
        }
        this.m_seen.add(id);
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public Map<String, Node> next() throws TrippiException {
        if (this.m_next == null) {
            return null;
        }
        Map<String, Node> last = this.m_next;
        this.m_next = this.getNext();
        return last;
    }

    @Override
    public String[] names() throws TrippiException {
        return this.m_wrapped.names();
    }

    @Override
    public void close() throws TrippiException {
        if (!this.m_closed) {
            this.m_wrapped.close();
            this.m_closed = true;
        }
    }

    @Override
    public void finalize() throws TrippiException {
        this.close();
    }
}

