/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.trippi.FlushErrorHandler;
import org.trippi.RDFUtil;
import org.trippi.TripleUpdate;
import org.trippi.TrippiException;
import org.trippi.impl.base.TriplestoreSession;
import org.trippi.impl.base.UpdateBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemUpdateBuffer
implements UpdateBuffer {
    private static Logger LOG = Logger.getLogger((String)MemUpdateBuffer.class.getName());
    private int m_safeCapacity;
    private int m_flushBatchSize;
    private List<TripleUpdate> m_buffer;
    private Object m_bufferLock = new Object();
    private FlushErrorHandler m_flushErrorHandler;

    public MemUpdateBuffer(int safeCapacity, int flushBatchSize) {
        this.m_safeCapacity = safeCapacity;
        this.m_flushBatchSize = flushBatchSize;
        this.m_buffer = Collections.synchronizedList(new ArrayList(safeCapacity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(List<Triple> triples) {
        MemUpdateBuffer.debugUpdate("Adding " + triples.size() + " triple ADDs to buffer", triples);
        Object object = this.m_bufferLock;
        synchronized (object) {
            this.m_buffer.addAll(TripleUpdate.get(1, triples));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Triple triple) {
        MemUpdateBuffer.debugUpdate("Adding 1 triple ADD to buffer", triple);
        Object object = this.m_bufferLock;
        synchronized (object) {
            this.m_buffer.add(TripleUpdate.get(1, triple));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(List<Triple> triples) {
        MemUpdateBuffer.debugUpdate("Adding " + triples.size() + " triple DELETEs to buffer", triples);
        Object object = this.m_bufferLock;
        synchronized (object) {
            this.m_buffer.addAll(TripleUpdate.get(0, triples));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Triple triple) {
        MemUpdateBuffer.debugUpdate("Adding 1 triple DELETE to buffer", triple);
        Object object = this.m_bufferLock;
        synchronized (object) {
            this.m_buffer.add(TripleUpdate.get(0, triple));
        }
    }

    private static void debugUpdate(String msg, Triple triple) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(msg + "\n" + RDFUtil.toString(triple)));
        }
    }

    private static void debugUpdate(String msg, List<Triple> triples) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(msg + "\n" + MemUpdateBuffer.tripleListToString(triples)));
        }
    }

    private static String tripleListToString(List<Triple> triples) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < triples.size(); ++i) {
            out.append(RDFUtil.toString(triples.get(i)) + "\n");
        }
        return out.toString();
    }

    @Override
    public int size() {
        try {
            return this.m_buffer.size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int safeCapacity() {
        return this.m_safeCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush(TriplestoreSession session) throws TrippiException {
        List<TripleUpdate> toFlush = null;
        Object object = this.m_bufferLock;
        synchronized (object) {
            if (this.m_buffer.size() > 0) {
                toFlush = this.m_buffer;
                this.m_buffer = Collections.synchronizedList(new ArrayList(this.m_safeCapacity));
            }
        }
        try {
            if (toFlush != null) {
                Set<Triple>[] updates = MemUpdateBuffer.normalize(toFlush.iterator(), toFlush.size());
                if (updates[0].size() > this.m_flushBatchSize) {
                    this.writeBatches(updates[0].iterator(), 1, session);
                } else {
                    this.writeBatch(1, updates[0], session);
                }
                if (updates[1].size() > this.m_flushBatchSize) {
                    this.writeBatches(updates[1].iterator(), 0, session);
                } else {
                    this.writeBatch(0, updates[1], session);
                }
            }
        }
        catch (TrippiException e) {
            if (this.m_flushErrorHandler != null) {
                this.m_flushErrorHandler.handleFlushError(toFlush, e);
            }
            throw e;
        }
    }

    @Override
    public void setFlushErrorHandler(FlushErrorHandler h) {
        this.m_flushErrorHandler = h;
    }

    private static Set<Triple>[] normalize(Iterator<TripleUpdate> iter, int size) {
        int initialCapacity = size / 2;
        HashSet<Triple> adds = new HashSet<Triple>(initialCapacity);
        HashSet<Triple> deletes = new HashSet<Triple>(initialCapacity);
        while (iter.hasNext()) {
            TripleUpdate update = iter.next();
            if (update.type == 1) {
                if (deletes.remove(update.triple)) continue;
                adds.add(update.triple);
                continue;
            }
            if (adds.remove(update.triple)) continue;
            deletes.add(update.triple);
        }
        return new Set[]{adds, deletes};
    }

    private void writeBatches(Iterator<Triple> iter, int updateType, TriplestoreSession session) throws TrippiException {
        HashSet<Triple> triples = new HashSet<Triple>();
        while (iter.hasNext()) {
            triples.add(iter.next());
            if (triples.size() != this.m_flushBatchSize) continue;
            this.writeBatch(updateType, triples, session);
            triples.clear();
        }
        if (triples.size() > 0) {
            this.writeBatch(updateType, triples, session);
        }
    }

    private void writeBatch(int type, Set<Triple> triples, TriplestoreSession session) throws TrippiException {
        if (type == 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Writing batch of " + triples.size() + " ADDs"));
            }
            session.add(triples);
        } else if (type == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Writing batch of " + triples.size() + " DELETEs"));
            }
            session.delete(triples);
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TripleUpdate> findBufferedUpdates(SubjectNode subject, PredicateNode predicate, ObjectNode object, int updateType) {
        ArrayList<TripleUpdate> updates = new ArrayList<TripleUpdate>();
        List<TripleUpdate> list = this.m_buffer;
        synchronized (list) {
            for (TripleUpdate tup : this.m_buffer) {
                if (updateType != 3 && tup.type != updateType) continue;
                Triple t = tup.triple;
                if (subject != null && !t.getSubject().equals(subject) || predicate != null && !t.getPredicate().equals(predicate) || object != null && !t.getObject().equals(object)) continue;
                updates.add(tup);
            }
        }
        return updates;
    }
}

