/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;
import org.trippi.impl.base.SynchronizedTripleIterator;
import org.trippi.impl.base.SynchronizedTupleIterator;
import org.trippi.impl.base.TriplestoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedTriplestoreSession
implements TriplestoreSession {
    private static final Logger logger = Logger.getLogger((String)SynchronizedTriplestoreSession.class.getName());
    private TriplestoreSession m_session;
    private List<Thread> m_lockQueue;
    private boolean m_closing = false;

    public SynchronizedTriplestoreSession(TriplestoreSession session) {
        this.m_session = session;
        this.m_lockQueue = new ArrayList<Thread>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Set<Triple> triples) throws UnsupportedOperationException, TrippiException {
        this.waitForLock(false);
        try {
            this.m_session.add(triples);
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Set<Triple> triples) throws UnsupportedOperationException, TrippiException {
        this.waitForLock(false);
        try {
            this.m_session.delete(triples);
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TupleIterator query(String queryText, String language) throws TrippiException {
        this.waitForLock(false);
        boolean success = false;
        try {
            SynchronizedTupleIterator iter = new SynchronizedTupleIterator(this.m_session.query(queryText, language), this);
            success = true;
            SynchronizedTupleIterator synchronizedTupleIterator = iter;
            return synchronizedTupleIterator;
        }
        finally {
            if (!success) {
                this.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TripleIterator findTriples(String lang, String queryText) throws TrippiException {
        this.waitForLock(false);
        boolean success = false;
        try {
            SynchronizedTripleIterator iter = new SynchronizedTripleIterator(this.m_session.findTriples(lang, queryText), this);
            success = true;
            SynchronizedTripleIterator synchronizedTripleIterator = iter;
            return synchronizedTripleIterator;
        }
        finally {
            if (!success) {
                this.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TripleIterator findTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object) throws TrippiException {
        this.waitForLock(false);
        boolean success = false;
        try {
            SynchronizedTripleIterator iter = new SynchronizedTripleIterator(this.m_session.findTriples(subject, predicate, object), this);
            success = true;
            SynchronizedTripleIterator synchronizedTripleIterator = iter;
            return synchronizedTripleIterator;
        }
        finally {
            if (!success) {
                this.releaseLock();
            }
        }
    }

    @Override
    public String[] listTupleLanguages() {
        return this.m_session.listTupleLanguages();
    }

    @Override
    public String[] listTripleLanguages() {
        return this.m_session.listTripleLanguages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws TrippiException {
        if (!this.m_closing) {
            this.waitForLock(true);
            try {
                this.m_session.close();
            }
            finally {
                this.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLock(boolean closing) throws TrippiException {
        if (closing) {
            this.m_closing = true;
        } else if (this.m_closing) {
            throw new TrippiException("Session is closing. Could not get a write lock.");
        }
        Thread ct = Thread.currentThread();
        String id = ct.getName();
        List<Thread> list = this.m_lockQueue;
        synchronized (list) {
            if (this.m_lockQueue.contains(ct)) {
                logger.warn((Object)("Thread '" + id + "' already in lockQueue, so not re-added."));
            } else {
                this.m_lockQueue.add(ct);
            }
        }
        logger.info((Object)("Thread '" + id + "' waiting for lock."));
        boolean gotLock = false;
        while (!gotLock) {
            List<Thread> list2 = this.m_lockQueue;
            synchronized (list2) {
                if (this.m_lockQueue.get(0) == ct) {
                    gotLock = true;
                }
                this.logLockStatus();
            }
            if (gotLock) continue;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {}
        }
        logger.info((Object)("Thread '" + id + "' obtained lock."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        List<Thread> list = this.m_lockQueue;
        synchronized (list) {
            String id = Thread.currentThread().getName();
            if (this.m_lockQueue.size() == 0 || this.m_lockQueue.get(0) != Thread.currentThread()) {
                logger.warn((Object)("Thread '" + id + "' did not have lock, so releaseLock() did nothing."));
                this.logLockStatus();
            } else {
                this.m_lockQueue.remove(0);
                logger.info((Object)("Thread '" + id + "' released lock."));
                this.logLockStatus();
            }
        }
    }

    private void logLockStatus() {
        int size = this.m_lockQueue.size();
        if (size == 0) {
            logger.info((Object)"Lock Status: FREE");
        } else {
            int waitCount = size - 1;
            Thread lockingThread = this.m_lockQueue.get(0);
            logger.info((Object)("Lock Status: LOCKER = '" + lockingThread.getName() + "', WAITING = " + waitCount));
        }
    }
}

