/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.multi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.trippi.FlushErrorHandler;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TripleUpdate;
import org.trippi.TriplestoreReader;
import org.trippi.TriplestoreWriter;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTriplestoreWriter
implements TriplestoreWriter {
    private static final Logger logger = Logger.getLogger((String)MultiTriplestoreWriter.class.getName());
    private TriplestoreReader m_reader;
    private TriplestoreWriter[] m_writers;

    public MultiTriplestoreWriter(TriplestoreReader reader, TriplestoreWriter[] writers) {
        this.m_reader = reader;
        this.m_writers = writers;
    }

    @Override
    public String[] listTripleLanguages() {
        return this.m_reader.listTripleLanguages();
    }

    @Override
    public String[] listTupleLanguages() {
        return this.m_reader.listTupleLanguages();
    }

    @Override
    public Map<String, String> getAliasMap() throws TrippiException {
        return this.m_reader.getAliasMap();
    }

    @Override
    public void setAliasMap(Map<String, String> aliasMap) throws TrippiException {
        this.m_reader.setAliasMap(aliasMap);
        for (int i = 0; i < this.m_writers.length; ++i) {
            this.m_writers[i].setAliasMap(aliasMap);
        }
    }

    @Override
    public int countTuples(String queryLang, String tupleQuery, int limit, boolean distinct) throws TrippiException {
        return this.m_reader.countTuples(queryLang, tupleQuery, limit, distinct);
    }

    @Override
    public TupleIterator findTuples(String queryLang, String tupleQuery, int limit, boolean distinct) throws TrippiException {
        return this.m_reader.findTuples(queryLang, tupleQuery, limit, distinct);
    }

    @Override
    public int countTriples(String queryLang, String tripleQuery, int limit, boolean distinct) throws TrippiException {
        return this.m_reader.countTriples(queryLang, tripleQuery, limit, distinct);
    }

    @Override
    public TripleIterator findTriples(String queryLang, String tripleQuery, int limit, boolean distinct) throws TrippiException {
        return this.m_reader.findTriples(queryLang, tripleQuery, limit, distinct);
    }

    @Override
    public int countTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object, int limit) throws TrippiException {
        return this.m_reader.countTriples(subject, predicate, object, limit);
    }

    @Override
    public TripleIterator findTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object, int limit) throws TrippiException {
        return this.m_reader.findTriples(subject, predicate, object, limit);
    }

    @Override
    public int countTriples(String queryLang, String tupleQuery, String tripleTemplate, int limit, boolean distinct) throws TrippiException {
        return this.m_reader.countTriples(queryLang, tupleQuery, tripleTemplate, limit, distinct);
    }

    @Override
    public TripleIterator findTriples(String queryLang, String tupleQuery, String tripleTemplate, int limit, boolean distinct) throws TrippiException {
        return this.m_reader.findTriples(queryLang, tupleQuery, tripleTemplate, limit, distinct);
    }

    @Override
    public void add(List<Triple> triples, boolean flush) {
        for (int i = 0; i < this.m_writers.length; ++i) {
            try {
                this.m_writers[i].add(triples, flush);
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)("Error adding triples from list (" + this.m_writers[i].getClass().getName() + ")"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(TripleIterator iter, boolean flush) throws IOException, TrippiException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("trippi-multiadd", "txt");
            FileOutputStream fout = new FileOutputStream(tempFile);
            try {
                iter.toStream(fout, RDFFormat.TURTLE);
            }
            finally {
                try {
                    fout.close();
                }
                catch (Exception e) {}
            }
            iter.close();
            for (int i = 0; i < this.m_writers.length; ++i) {
                iter = TripleIterator.fromStream(new FileInputStream(tempFile), RDFFormat.TURTLE);
                try {
                    this.m_writers[i].add(iter, flush);
                    continue;
                }
                catch (Exception e) {
                    logger.warn((Object)("Error adding triples from iterator (" + this.m_writers[i].getClass().getName() + ")"), (Throwable)e);
                }
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    @Override
    public void add(Triple triple, boolean flush) {
        for (int i = 0; i < this.m_writers.length; ++i) {
            try {
                this.m_writers[i].add(triple, flush);
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)("Error adding one triple (" + this.m_writers[i].getClass().getName() + ")"), (Throwable)e);
            }
        }
    }

    @Override
    public void delete(List<Triple> triples, boolean flush) {
        for (int i = 0; i < this.m_writers.length; ++i) {
            try {
                this.m_writers[i].delete(triples, flush);
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)("Error deleting triples from list (" + this.m_writers[i].getClass().getName() + ")"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(TripleIterator iter, boolean flush) throws IOException, TrippiException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("trippi-multidel", "txt");
            FileOutputStream fout = new FileOutputStream(tempFile);
            try {
                iter.toStream(fout, RDFFormat.TURTLE);
            }
            finally {
                try {
                    fout.close();
                }
                catch (Exception e) {}
            }
            iter.close();
            for (int i = 0; i < this.m_writers.length; ++i) {
                iter = TripleIterator.fromStream(new FileInputStream(tempFile), RDFFormat.TURTLE);
                try {
                    this.m_writers[i].delete(iter, flush);
                    continue;
                }
                catch (Exception e) {
                    logger.warn((Object)("Error deleting triples from iterator (" + this.m_writers[i].getClass().getName() + ")"), (Throwable)e);
                }
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    @Override
    public void delete(Triple triple, boolean flush) {
        for (int i = 0; i < this.m_writers.length; ++i) {
            try {
                this.m_writers[i].delete(triple, flush);
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)("Error deleting one triple (" + this.m_writers[i].getClass().getName() + ")"), (Throwable)e);
            }
        }
    }

    @Override
    public void flushBuffer() {
        for (int i = 0; i < this.m_writers.length; ++i) {
            try {
                this.m_writers[i].flushBuffer();
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)("Error flushing (" + this.m_writers[i].getClass().getName() + ")"), (Throwable)e);
            }
        }
    }

    @Override
    public void setFlushErrorHandler(FlushErrorHandler h) {
        for (int i = 0; i < this.m_writers.length; ++i) {
            try {
                this.m_writers[i].setFlushErrorHandler(h);
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)("Error setting error handler (" + this.m_writers[i].getClass().getName() + ")"), (Throwable)e);
            }
        }
    }

    @Override
    public int getBufferSize() {
        int biggest = 0;
        for (int i = 0; i < this.m_writers.length; ++i) {
            if (this.m_writers[i].getBufferSize() <= biggest) continue;
            biggest = this.m_writers[i].getBufferSize();
        }
        return biggest;
    }

    @Override
    public void close() {
        for (int i = 0; i < this.m_writers.length; ++i) {
            try {
                this.m_writers[i].close();
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)("Error closing writer (" + this.m_writers[i].getClass().getName() + ")"), (Throwable)e);
            }
        }
    }

    @Override
    public List<TripleUpdate> findBufferedUpdates(SubjectNode subject, PredicateNode predicate, ObjectNode object, int updateType) {
        ArrayList<TripleUpdate> triples = new ArrayList<TripleUpdate>();
        for (int i = 0; i < this.m_writers.length; ++i) {
            triples.addAll(this.m_writers[i].findBufferedUpdates(subject, predicate, object, updateType));
        }
        return triples;
    }
}

