/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jrdf.graph.GraphElementFactoryException;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.ntriples.NTriplesParser;
import org.openrdf.rio.rdfxml.RDFXMLParser;
import org.openrdf.rio.turtle.TurtleParser;
import org.trippi.RDFFormat;
import org.trippi.RDFUtil;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;

public class RIOTripleIterator
extends TripleIterator
implements RDFHandler,
Runnable {
    private static final Logger logger = Logger.getLogger((String)RIOTripleIterator.class.getName());
    private InputStream m_in;
    private RDFParser m_parser;
    private String m_baseURI;
    private Triple m_bucket;
    private Triple m_next;
    private boolean m_closed = false;
    private boolean m_finishedParsing = false;
    private Exception m_parseException = null;
    private RDFUtil m_util;
    private int m_tripleCount = 0;
    private Map<String, String> m_aliases;

    public RIOTripleIterator(InputStream in, RDFParser parser, String baseURI) throws TrippiException {
        this.m_in = in;
        this.m_parser = parser;
        this.m_aliases = new HashMap<String, String>();
        this.m_baseURI = baseURI;
        this.m_parser.setRDFHandler((RDFHandler)this);
        this.m_parser.setVerifyData(true);
        this.m_parser.setStopAtFirstError(false);
        try {
            this.m_util = new RDFUtil();
        }
        catch (Exception e) {
            // empty catch block
        }
        Thread parserThread = new Thread(this);
        logger.info((Object)"Starting parse thread");
        parserThread.start();
        this.m_next = this.getNext();
    }

    public void handleNamespace(String prefix, String uri) {
        if (prefix != null && !prefix.equals("")) {
            this.m_aliases.put(prefix, uri);
            this.setAliasMap(this.m_aliases);
        }
    }

    private synchronized Triple getNext() throws TrippiException {
        while (this.m_bucket == null && !this.m_finishedParsing) {
            try {
                this.wait(5L);
            }
            catch (InterruptedException e) {}
        }
        if (this.m_finishedParsing && this.m_parseException != null) {
            throw new TrippiException("RDF Parse Error.", this.m_parseException);
        }
        if (this.m_bucket == null) {
            logger.info((Object)("Finished parsing " + this.m_tripleCount + " triples."));
            return null;
        }
        Triple triple = this.m_bucket;
        this.m_bucket = null;
        ++this.m_tripleCount;
        if (this.m_tripleCount % 1000 == 0) {
            logger.info((Object)("Iterated " + this.m_tripleCount + ", mem free = " + Runtime.getRuntime().freeMemory()));
        }
        this.notifyAll();
        return triple;
    }

    public boolean hasNext() throws TrippiException {
        return this.m_next != null;
    }

    public Triple next() throws TrippiException {
        if (this.m_next == null) {
            return null;
        }
        Triple last = this.m_next;
        this.m_next = this.getNext();
        return last;
    }

    public void close() throws TrippiException {
        if (!this.m_closed) {
            this.m_closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.m_parser.parse(this.m_in, this.m_baseURI);
        }
        catch (Exception e) {
            this.m_parseException = e;
        }
        finally {
            this.m_finishedParsing = true;
            try {
                this.m_in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void handleStatement(Resource subject, org.openrdf.model.URI predicate, Value object) throws GraphElementFactoryException, URISyntaxException {
        Triple triple = null;
        triple = this.m_util.createTriple(this.subjectNode(subject), this.predicateNode(predicate), this.objectNode(object));
        this.put(triple);
    }

    private synchronized void put(Triple triple) {
        while (this.m_bucket != null && !this.m_closed) {
            try {
                this.wait(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.m_closed) {
            return;
        }
        this.m_bucket = triple;
        this.notifyAll();
    }

    private SubjectNode subjectNode(Resource subject) throws GraphElementFactoryException, URISyntaxException {
        if (subject instanceof org.openrdf.model.URI) {
            return this.m_util.createResource(new URI(((org.openrdf.model.URI)subject).stringValue()));
        }
        return this.m_util.createResource(((BNode)subject).getID().hashCode());
    }

    private PredicateNode predicateNode(org.openrdf.model.URI predicate) throws GraphElementFactoryException, URISyntaxException {
        return this.m_util.createResource(new URI(predicate.stringValue()));
    }

    private ObjectNode objectNode(Value object) throws GraphElementFactoryException, URISyntaxException {
        if (object instanceof org.openrdf.model.URI) {
            return this.m_util.createResource(new URI(((org.openrdf.model.URI)object).stringValue()));
        }
        if (object instanceof Literal) {
            Literal lit = (Literal)object;
            org.openrdf.model.URI uri = lit.getDatatype();
            String lang = lit.getLanguage();
            if (uri != null) {
                return this.m_util.createLiteral(lit.getLabel(), new URI(uri.toString()));
            }
            if (lang != null && !lang.equals("")) {
                return this.m_util.createLiteral(lit.getLabel(), lang);
            }
            return this.m_util.createLiteral(lit.getLabel());
        }
        return this.m_util.createResource(((BNode)object).getID().hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        RDFXMLParser parser;
        File f = new File(args[0]);
        String baseURI = "http://localhost/";
        RDFFormat format = RDFFormat.forName(args[1]);
        if (format == RDFFormat.RDF_XML) {
            parser = new RDFXMLParser();
        } else if (format == RDFFormat.TURTLE) {
            parser = new TurtleParser();
        } else if (format == RDFFormat.N_TRIPLES) {
            parser = new NTriplesParser();
        } else {
            throw new TrippiException("Unsupported input format: " + format.getName());
        }
        RIOTripleIterator iter = new RIOTripleIterator(new FileInputStream(f), (RDFParser)parser, baseURI);
        try {
            iter.toStream(System.out, RDFFormat.forName(args[2]));
        }
        finally {
            ((TripleIterator)iter).close();
        }
    }

    public void endRDF() throws RDFHandlerException {
    }

    public void handleComment(String arg0) throws RDFHandlerException {
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        Triple triple = null;
        try {
            triple = this.m_util.createTriple(this.subjectNode(st.getSubject()), this.predicateNode(st.getPredicate()), this.objectNode(st.getObject()));
        }
        catch (GraphElementFactoryException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
        this.put(triple);
    }

    public void startRDF() throws RDFHandlerException {
    }
}

