/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Map;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.Literal;
import org.jrdf.graph.Node;
import org.jrdf.graph.URIReference;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;
import org.trippi.io.TupleWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparqlTupleWriter
extends TupleWriter {
    private PrintWriter m_out;
    private Map<String, String> m_aliases;

    public SparqlTupleWriter(OutputStream out, Map<String, String> aliases) throws TrippiException {
        try {
            this.m_out = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
            this.m_aliases = aliases;
        }
        catch (IOException e) {
            throw new TrippiException("Error setting up writer", e);
        }
    }

    @Override
    public int write(TupleIterator iter) throws TrippiException {
        try {
            this.m_out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.doEntities();
            this.m_out.println("<sparql xmlns=\"http://www.w3.org/2001/sw/DataAccess/rf1/result\">");
            String[] names = iter.names();
            this.m_out.println("  <head>");
            for (int i = 0; i < names.length; ++i) {
                this.m_out.println("    <variable name=\"" + names[i] + "\"/>");
            }
            this.m_out.println("  </head>");
            this.m_out.println("  <results>");
            int count = 0;
            while (iter.hasNext()) {
                this.m_out.println("    <result>");
                Map<String, Node> result = iter.next();
                for (int i = 0; i < names.length; ++i) {
                    this.m_out.print("      <" + names[i]);
                    Node n = result.get(names[i]);
                    if (n == null) {
                        this.m_out.println(" bound=\"false\"/>");
                        continue;
                    }
                    if (n instanceof URIReference) {
                        String uriString = ((URIReference)n).getURI().toString();
                        this.m_out.println(" uri=\"" + this.getURI(uriString) + "\"/>");
                        continue;
                    }
                    if (n instanceof BlankNode) {
                        String id = "blank" + n.hashCode();
                        this.m_out.println(" bnodeid=\"" + id + "\"/>");
                        continue;
                    }
                    if (n instanceof Literal) {
                        String lang;
                        Literal lit = (Literal)n;
                        URI dType = lit.getDatatypeURI();
                        if (dType != null) {
                            this.m_out.print(" datatype=\"" + this.getURI(dType.toString()) + "\"");
                        }
                        if ((lang = lit.getLanguage()) != null) {
                            this.m_out.print(" xml:lang=\"" + lang + "\"");
                        }
                        this.m_out.println(">" + SparqlTupleWriter.enc(lit.getLexicalForm()) + "</" + names[i] + ">");
                        continue;
                    }
                    throw new TrippiException("Unrecognized node type: " + n.getClass().getName());
                }
                this.m_out.println("    </result>");
                this.m_out.flush();
                ++count;
            }
            this.m_out.println("  </results>");
            this.m_out.println("</sparql>");
            this.m_out.flush();
            iter.close();
            return count;
        }
        catch (IOException e) {
            throw new TrippiException("Error writing", e);
        }
    }

    private void doEntities() throws IOException {
        if (this.m_aliases == null || this.m_aliases.keySet().size() == 0) {
            return;
        }
        this.m_out.println("<!DOCTYPE sparql [");
        for (String ent : this.m_aliases.keySet()) {
            String value = this.m_aliases.get(ent);
            this.m_out.println("  <!ENTITY " + ent + " \"" + value + "\">");
        }
        this.m_out.println("]>");
    }

    private String getURI(String s) {
        if (this.m_aliases == null || this.m_aliases.keySet().size() == 0) {
            return SparqlTupleWriter.enc(s);
        }
        for (String alias : this.m_aliases.keySet()) {
            String prefix = this.m_aliases.get(alias);
            if (!s.startsWith(prefix)) continue;
            return "&" + alias + ";" + SparqlTupleWriter.enc(s.substring(prefix.length()));
        }
        return SparqlTupleWriter.enc(s);
    }
}

