/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TriplestoreConnector;
import org.trippi.TriplestoreReader;
import org.trippi.TriplestoreWriter;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;

public class TrippiServer {
    private TriplestoreReader m_reader;
    private TriplestoreWriter m_writer;

    public TrippiServer(TriplestoreReader reader) {
        this.m_reader = reader;
    }

    public TrippiServer(TriplestoreConnector conn) {
        this.m_reader = conn.getReader();
        this.m_writer = conn.getWriter();
    }

    public TrippiServer(TriplestoreWriter writer) {
        this((TriplestoreReader)writer);
        this.m_writer = writer;
    }

    public TriplestoreReader getReader() {
        return this.m_reader;
    }

    public TriplestoreWriter getWriter() {
        return this.m_writer;
    }

    private static RDFFormat getResponseFormat(String name, boolean tupleQuery) throws TrippiException {
        if (name != null) {
            return RDFFormat.forName(name);
        }
        if (tupleQuery) {
            return RDFFormat.SPARQL;
        }
        return RDFFormat.TURTLE;
    }

    public static String getResponseMediaType(String formatName, boolean isTupleQuery, boolean useDumbType) throws TrippiException {
        RDFFormat format = TrippiServer.getResponseFormat(formatName, isTupleQuery);
        String formatMediaType = format.getMediaType();
        return TrippiServer.getMediaType(format.getMediaType(), useDumbType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String find(String type, String template, String lang, String query, String limit, String distinct, String format, String dumbTypes, String flush, OutputStream out) throws IOException, TrippiException {
        if (type == null || type.equals("")) {
            type = "tuples";
        }
        if (template != null && template.equals("")) {
            template = null;
        }
        if (template != null && template.startsWith("http://")) {
            template = this.loadContentAsString(template);
        }
        if (limit == null || limit.equals("")) {
            limit = "0";
        }
        boolean doDistinct = TrippiServer.getBoolean(distinct, false);
        boolean useDumbTypes = TrippiServer.getBoolean(dumbTypes, false);
        boolean doFlush = TrippiServer.getBoolean(flush, false);
        if (doFlush && this.m_writer != null) {
            this.m_writer.flushBuffer();
        }
        RDFFormat fmt = TrippiServer.getResponseFormat(format, type.equals("tuples"));
        if (lang == null || lang.equals("")) {
            throw new TrippiException("Parameter 'lang' must be specified (rdql, itql, spo, etc)");
        }
        if (query == null || query.equals("")) {
            throw new TrippiException("Parameter 'query' must be specified (the query text)");
        }
        if (query.startsWith("http://")) {
            query = this.loadContentAsString(query);
        }
        if (type.equals("tuples")) {
            TupleIterator iter = this.m_reader.findTuples(lang, query, Integer.parseInt(limit), doDistinct);
            try {
                iter.toStream(out, fmt);
                String string = TrippiServer.getMediaType(fmt.getMediaType(), useDumbTypes);
                return string;
            }
            finally {
                iter.close();
            }
        }
        if (type.equals("triples")) {
            TripleIterator iter = null;
            try {
                iter = template == null ? this.m_reader.findTriples(lang, query, Integer.parseInt(limit), doDistinct) : this.m_reader.findTriples(lang, query, template, Integer.parseInt(limit), doDistinct);
                iter.toStream(out, fmt);
                String string = TrippiServer.getMediaType(fmt.getMediaType(), useDumbTypes);
                return string;
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
            }
        }
        throw new TrippiException("Unrecognized response type: " + type);
    }

    private String loadContentAsString(String url) throws IOException {
        InputStream in = new URL(url).openStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.sendStream(in, out);
        return out.toString("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStream(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getMediaType(String in, boolean dumb) {
        if (!dumb) {
            return in;
        }
        if (in.endsWith("xml")) {
            return "text/xml";
        }
        return "text/plain";
    }

    public static boolean getBoolean(String in, boolean defaultValue) {
        if (in != null && in.length() > 0) {
            return !in.toLowerCase().startsWith("f") && !in.toLowerCase().equals("off");
        }
        return defaultValue;
    }
}

