/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.ui.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jrdf.graph.Triple;
import org.trippi.ConnectorDescriptor;
import org.trippi.ConnectorParameter;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TripleMaker;
import org.trippi.TriplePattern;
import org.trippi.TriplestoreConnector;
import org.trippi.Trippi;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;
import org.trippi.config.TrippiConfig;
import org.trippi.config.TrippiProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrippiConsole {
    private static final Logger logger = Logger.getLogger((String)TrippiConsole.class.getName());
    private TrippiConfig m_config;
    private boolean m_trace = false;
    private TrippiProfile m_profile;
    private TriplestoreConnector m_connector;
    private BufferedReader m_reader;
    private boolean m_distinct = false;
    private int m_limit = 0;
    private RDFFormat m_tupleForm = RDFFormat.TSV;
    private RDFFormat m_tripleForm = RDFFormat.TURTLE;

    public TrippiConsole(TrippiConfig config, TrippiProfile profile) throws Exception {
        this(config, profile, System.in);
    }

    public TrippiConsole(TrippiConfig config, TrippiProfile profile, InputStream in) throws Exception {
        this.m_config = config;
        this.m_reader = new BufferedReader(new InputStreamReader(in));
        System.out.println("Welcome to the Trippi v" + Trippi.VERSION + " Console.");
        if (profile == null) {
            System.out.println("You are not connected to a triplestore.");
        } else {
            this.connect(profile);
        }
        System.out.println("\nType 'help;' for help.\n");
        boolean done = false;
        while (!done) {
            done = this.inputAndRun();
        }
        if (this.m_connector != null) {
            this.m_connector.close();
        }
    }

    private void connect(TrippiProfile profile) {
        System.out.print("Connecting to " + profile.getLabel() + "...");
        try {
            this.m_connector = profile.getConnector();
            this.m_connector.getReader().setAliasMap(this.m_config.getAliasMap());
            this.m_profile = profile;
            System.out.println("OK");
        }
        catch (Exception e) {
            System.out.println("\nERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inputAndRun() throws IOException {
        String prompt = this.m_profile == null ? "trippi> " : "trippi/" + this.m_profile.getId() + "> ";
        System.out.print(prompt);
        StringBuffer input = new StringBuffer();
        boolean finished = false;
        boolean done = false;
        while (!done) {
            String line = this.m_reader.readLine();
            if (line == null) {
                done = true;
                finished = true;
                continue;
            }
            if ((line = line.trim()).endsWith(";")) {
                input.append(line.substring(0, line.length() - 1).trim());
                done = true;
                continue;
            }
            input.append(line + " ");
            System.out.print("> ");
        }
        if (finished) {
            return true;
        }
        String cmdLine = input.toString().trim();
        String u = cmdLine.toUpperCase();
        if (u.startsWith("EXIT") || u.startsWith("QUIT")) {
            return true;
        }
        try {
            System.out.println("");
            String[] tokens = cmdLine.split(" ");
            if (tokens == null || tokens.length < 2) {
                this.interpret(cmdLine.toLowerCase(), "");
            } else {
                this.interpret(tokens[0].toLowerCase(), cmdLine.substring(tokens[0].length() + 1));
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            if (this.m_trace) {
                this.printFullTrace(e);
            }
        }
        finally {
            System.out.println("");
        }
        return false;
    }

    private void printFullTrace(Throwable e) {
        int level = 0;
        while (e != null) {
            if (level > 0) {
                System.out.println("CAUSED BY:");
            }
            ++level;
            e.printStackTrace();
            e = e.getCause();
        }
    }

    public void doDateTest(String cmd) throws Exception {
        if (cmd == null || cmd.equals("")) {
            System.out.println("Usage: datetest [plain|double|dateTime] [numTriples]");
        } else {
            String[] parts = cmd.split(" ");
            if (parts.length == 2) {
                int type;
                int num = Integer.parseInt(parts[1]);
                if (parts[0].equals("plain")) {
                    type = 0;
                } else if (parts[0].equals("double")) {
                    type = 1;
                } else if (parts[0].equals("dateTime")) {
                    type = 2;
                } else {
                    throw new TrippiException("Unrecognized datetest type: " + parts[0]);
                }
                System.out.print("Adding " + num + " <resource:NUM> <urn:date> (" + parts[0] + ") triples...");
                long startTime = System.currentTimeMillis();
                String property = "urn:date";
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                for (int i = 0; i < num; ++i) {
                    Triple triple;
                    String resource = "resource:" + i;
                    if (type == 1) {
                        triple = TripleMaker.createTyped(resource, property, "" + i, "http://www.w3.org/2001/XMLSchema#double");
                    } else {
                        long epochMS = i * 1000;
                        Date date = new Date();
                        date.setTime(epochMS);
                        String dateString = formatter.format(date);
                        triple = type == 0 ? TripleMaker.createPlain(resource, property, dateString) : TripleMaker.createTyped(resource, property, dateString, "http://www.w3.org/2001/XMLSchema#dateTime");
                    }
                    this.m_connector.getWriter().add(triple, false);
                }
                System.out.println("OK.");
                long endTime = System.currentTimeMillis();
                double elapsed = (double)(endTime - startTime) / 1000.0;
                System.out.println(elapsed + " seconds elapsed.");
            } else {
                System.out.println("Usage: datetest [plain|double|dateTime] [numTriples]");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void interpret(String cmd, String rest) throws Exception {
        if (cmd.equals("help")) {
            this.doHelp();
            return;
        } else if (cmd.equals("profiles")) {
            this.doProfiles();
            return;
        } else if (cmd.equals("connectors")) {
            this.doConnectors();
            return;
        } else if (cmd.equals("use")) {
            this.doUse(rest);
            return;
        } else if (cmd.equals("create")) {
            this.doCreate();
            return;
        } else if (cmd.equals("alias")) {
            this.doAlias(rest);
            return;
        } else if (cmd.equals("datetest")) {
            this.checkProfile();
            this.doDateTest(rest);
            return;
        } else if (cmd.equals("add")) {
            this.checkProfile();
            this.doAdd(rest);
            return;
        } else if (cmd.equals("delete")) {
            this.checkProfile();
            this.doDelete(rest);
            return;
        } else if (cmd.equals("tuples")) {
            this.checkProfile();
            this.doTuples(rest, false);
            return;
        } else if (cmd.equals("count")) {
            this.checkProfile();
            if (rest.startsWith("tuples")) {
                this.doTuples(rest.substring(7), true);
                return;
            } else if (rest.startsWith("triples")) {
                this.doTriples(rest.substring(8), true);
                return;
            } else {
                if (!rest.equals("")) throw new TrippiException("Bad syntax, try count by itself or count [tuples ..|triples ..]");
                this.doTriples("spo * * *", true);
            }
            return;
        } else if (cmd.equals("triples")) {
            this.checkProfile();
            this.doTriples(rest, false);
            return;
        } else if (cmd.equals("dump")) {
            this.checkProfile();
            this.doDump(rest);
            return;
        } else if (cmd.startsWith("triplef")) {
            if (rest.equals("")) {
                System.out.println("Current Triple Result Format: " + this.m_tripleForm.getName());
                System.out.print("Formats Supported: ");
                RDFFormat[] p = TripleIterator.OUTPUT_FORMATS;
                for (int i = 0; i < p.length; ++i) {
                    if (i > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(p[i].getName());
                }
                System.out.println("");
                return;
            } else {
                this.m_tripleForm = RDFFormat.forName(rest);
                System.out.println("New Triple Result Format: " + this.m_tripleForm.getName());
            }
            return;
        } else if (cmd.startsWith("tuplef")) {
            if (rest.equals("")) {
                System.out.println("Current Tuple Result Format: " + this.m_tupleForm.getName());
                System.out.print("Formats Supported: ");
                RDFFormat[] p = TupleIterator.OUTPUT_FORMATS;
                for (int i = 0; i < p.length; ++i) {
                    if (i > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(p[i].getName());
                }
                System.out.println("");
                return;
            } else {
                this.m_tupleForm = RDFFormat.forName(rest);
                System.out.println("New Tuple Result Format: " + this.m_tupleForm.getName());
            }
            return;
        } else if (cmd.equals("load")) {
            this.checkProfile();
            this.doLoad(rest);
            return;
        } else if (cmd.equals("close")) {
            this.checkProfile();
            System.out.print("Closing...");
            this.m_connector.close();
            System.out.println("OK.");
            this.m_connector = null;
            this.m_profile = null;
            return;
        } else if (cmd.equals("limit")) {
            this.doLimit(rest);
            return;
        } else if (cmd.equals("distinct")) {
            if (this.m_distinct) {
                this.m_distinct = false;
                System.out.println("Forced distinct mode is off.");
                return;
            } else {
                this.m_distinct = true;
                System.out.println("Forced distinct mode is on.");
            }
            return;
        } else {
            if (!cmd.equals("trace")) throw new TrippiException("Unrecognized command: " + cmd);
            if (this.m_trace) {
                this.m_trace = false;
                System.out.println("Tracing is disabled.");
                return;
            } else {
                this.m_trace = true;
                System.out.println("Tracing is enabled.");
            }
        }
    }

    private static String doAliasReplacements(String string, Map<String, String> aliasMap) {
        String out = string;
        for (String alias : aliasMap.keySet()) {
            String fullForm = aliasMap.get(alias);
            out = out.replaceAll("<" + alias + ":", "<" + fullForm);
            out = out.replaceAll("\\^\\^" + alias + ":", "^^" + fullForm);
        }
        if (!string.equals(out)) {
            logger.info((Object)("Substituted aliases, string is now: " + out));
        }
        return out;
    }

    public void doAdd(String tripleString) throws Exception {
        List<Triple> triples = TriplePattern.parse(TrippiConsole.doAliasReplacements(tripleString, this.m_connector.getReader().getAliasMap()), this.m_connector.getElementFactory());
        System.out.print("Adding " + triples.size() + " triples...");
        this.m_connector.getWriter().add(triples, false);
        System.out.println("OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(String tripleString) throws Exception {
        if (tripleString.equals("*") || tripleString.equalsIgnoreCase("all")) {
            System.out.print("Deleting ALL triples...");
            TripleIterator iter = this.m_connector.getReader().findTriples(null, null, null, -1);
            try {
                this.m_connector.getWriter().delete(iter, false);
            }
            finally {
                iter.close();
            }
        } else {
            List<Triple> triples = TriplePattern.parse(TrippiConsole.doAliasReplacements(tripleString, this.m_connector.getReader().getAliasMap()), this.m_connector.getElementFactory());
            System.out.print("Deleting " + triples.size() + " triples...");
            this.m_connector.getWriter().delete(triples, false);
        }
        System.out.println("OK");
    }

    public void doLimit(String rest) throws Exception {
        if (rest.equals("")) {
            if (this.m_limit < 1) {
                System.out.println("Current result limit: None");
            } else {
                System.out.println("Current result limit: " + this.m_limit);
            }
        } else {
            this.m_limit = Integer.parseInt(rest);
            if (this.m_limit < 1) {
                System.out.println("New result limit: None");
            } else {
                System.out.println("New result limit: " + this.m_limit);
            }
        }
    }

    public void doAlias(String rest) throws Exception {
        Map<String, String> aliases = this.m_config.getAliasMap();
        if (rest.equals("")) {
            for (String alias : aliases.keySet()) {
                String value = aliases.get(alias);
                System.out.println(alias + "\t" + value);
            }
        } else if (rest.equals("!")) {
            HashMap<String, String> emptyMap = new HashMap<String, String>();
            this.m_config.setAliasMap(emptyMap);
            if (this.m_connector != null) {
                this.m_connector.getReader().setAliasMap(emptyMap);
            }
            System.out.println("Cleared all aliases.");
        } else if (rest.indexOf(" ") == -1) {
            String val = aliases.get(rest);
            if (val == null) {
                throw new TrippiException("No such alias: " + rest);
            }
            System.out.println(rest + "\t" + val);
        } else {
            String[] tokens = rest.split(" ");
            if (tokens.length == 2) {
                if (tokens[1].equals("!")) {
                    aliases.remove(tokens[0]);
                    this.m_config.setAliasMap(aliases);
                    if (this.m_connector != null) {
                        this.m_connector.getReader().setAliasMap(aliases);
                    }
                    System.out.println("Cleared alias: " + tokens[0]);
                } else {
                    aliases.put(tokens[0], tokens[1]);
                    this.m_config.setAliasMap(aliases);
                    if (this.m_connector != null) {
                        this.m_connector.getReader().setAliasMap(aliases);
                    }
                    System.out.println(tokens[0] + " is now an alias for " + tokens[1]);
                }
            }
        }
    }

    public void checkProfile() throws Exception {
        if (this.m_profile == null) {
            throw new TrippiException("No profile in use.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDump(String filename) throws Exception {
        System.out.print("Dumping triples (in " + this.m_tripleForm.getName() + " format) to " + filename + "...");
        TripleIterator iter = this.m_connector.getReader().findTriples(null, null, null, 0);
        iter.setAliasMap(this.m_connector.getReader().getAliasMap());
        FileOutputStream out = new FileOutputStream(new File(filename));
        try {
            iter.toStream(out, this.m_tripleForm);
        }
        finally {
            out.close();
        }
        System.out.println("OK");
    }

    public void doLoad(String filename) throws Exception {
        System.out.print("Loading triples (in " + this.m_tripleForm.getName() + " format) from " + filename + "...");
        this.m_connector.getWriter().add(TripleIterator.fromStream(new FileInputStream(new File(filename)), this.m_tripleForm), false);
        System.out.println("OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTuples(String parms, boolean count) throws Exception {
        String[] tokens = parms.split(" ");
        if (tokens.length < 2) {
            throw new TrippiException("No query specified.");
        }
        String lang = tokens[0];
        String query = parms.substring(parms.indexOf(" ")).trim();
        TupleIterator iter = null;
        try {
            long startTime = System.currentTimeMillis();
            iter = this.m_connector.getReader().findTuples(lang, query, this.m_limit, this.m_distinct);
            int n = 0;
            if (count) {
                n = iter.count();
            } else {
                iter.setAliasMap(this.m_connector.getReader().getAliasMap());
                n = iter.toStream(System.out, this.m_tupleForm);
            }
            System.out.println("Total Tuples   : " + n);
            long endTime = System.currentTimeMillis();
            double elapsedSeconds = ((double)endTime - (double)startTime) / 1000.0;
            System.out.println("Seconds Elapsed: " + elapsedSeconds);
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTriples(String parms, boolean count) throws Exception {
        TripleIterator iter = null;
        try {
            int rightPos = parms.indexOf(")");
            long startTime = System.currentTimeMillis();
            if (parms.startsWith("(") && rightPos != -1) {
                String pattern = parms.substring(0, rightPos);
                String rest = parms.substring(rightPos + 1).trim();
                String[] t = rest.split(" ");
                if (t.length < 2) {
                    throw new TrippiException("Bad syntax, need lang and query.");
                }
                String lang = t[0];
                String query = rest.substring(rest.indexOf(" ")).trim();
                iter = this.m_connector.getReader().findTriples(lang, query, pattern, this.m_limit, this.m_distinct);
            } else {
                String[] tokens = parms.split(" ");
                if (tokens.length < 2) {
                    throw new TrippiException("Triple query must have at least two parameters.");
                }
                String lang = tokens[0];
                String query = parms.substring(parms.indexOf(" ")).trim();
                iter = this.m_connector.getReader().findTriples(lang, query, this.m_limit, this.m_distinct);
            }
            this.doTriples(iter, count, startTime);
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    private void doTriples(TripleIterator iter, boolean count, long startTime) throws Exception {
        int n = 0;
        if (count) {
            n = iter.count();
        } else {
            iter.setAliasMap(this.m_connector.getReader().getAliasMap());
            n = iter.toStream(System.out, this.m_tripleForm);
            System.out.println("\n");
        }
        System.out.println("Total Triples  : " + n);
        long endTime = System.currentTimeMillis();
        double elapsedSeconds = ((double)endTime - (double)startTime) / 1000.0;
        System.out.println("Seconds Elapsed: " + elapsedSeconds);
    }

    public void doCreate() throws Exception {
        System.out.println("Creating a new profile. To cancel at any time, enter CANCEL.\n");
        boolean done = false;
        boolean canceled = false;
        String className = null;
        ConnectorDescriptor descriptor = null;
        while (!done) {
            System.out.print("Enter the connector class name: ");
            className = this.m_reader.readLine();
            if (className == null || className.equalsIgnoreCase("CANCEL")) {
                canceled = true;
                done = true;
                continue;
            }
            if (className.equals("")) continue;
            try {
                descriptor = TriplestoreConnector.getDescriptor(className);
                done = true;
            }
            catch (TrippiException e) {
                System.out.println("ERROR: " + e.getMessage());
            }
        }
        if (canceled) {
            System.out.println("Canceled.");
        } else {
            String id = null;
            done = false;
            canceled = false;
            while (!done) {
                System.out.print("Enter a short id for the new profile: ");
                id = this.m_reader.readLine();
                if (id == null || id.equalsIgnoreCase("CANCEL")) {
                    canceled = true;
                    done = true;
                    continue;
                }
                if (id.equals("")) continue;
                TrippiProfile p = this.m_config.getProfiles().get(id);
                if (p != null) {
                    System.out.println("ERROR: A profile with that id already exists.");
                    continue;
                }
                done = true;
            }
            if (canceled) {
                System.out.println("Canceled.");
            } else {
                String label = null;
                done = false;
                canceled = false;
                while (!done) {
                    System.out.print("Enter a label for the new profile: ");
                    label = this.m_reader.readLine();
                    if (label == null || label.equalsIgnoreCase("CANCEL")) {
                        canceled = true;
                        done = true;
                        continue;
                    }
                    if (label.equals("")) continue;
                    done = true;
                }
                if (canceled) {
                    System.out.println("Canceled.");
                } else {
                    TrippiProfile profile = this.configure(id, label, className, descriptor);
                    if (profile != null) {
                        Map<String, TrippiProfile> profileMap = this.m_config.getProfiles();
                        profileMap.put(id, profile);
                        this.m_config.setProfiles(profileMap);
                        System.out.println("\nProfile created.  Type 'use " + id + ";' to use it.");
                    } else {
                        System.out.println("Canceled.");
                    }
                }
            }
        }
    }

    public TrippiProfile configure(String id, String label, String className, ConnectorDescriptor descriptor) throws Exception {
        System.out.println("");
        this.printConnectorInfo(descriptor, className);
        Map<String, String> config = this.configure(descriptor.getParameters());
        if (config == null) {
            return null;
        }
        return new TrippiProfile(id, label, className, config);
    }

    private Map<String, String> configure(List<ConnectorParameter> params) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<ConnectorParameter> iter = params.iterator();
        while (iter.hasNext()) {
            Map<String, String> m = this.configure(iter.next());
            if (m == null) {
                return null;
            }
            map.putAll(m);
        }
        return map;
    }

    private Map<String, String> configure(ConnectorParameter param) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        System.out.println("");
        System.out.println("Parameter   : " + param.getName());
        String desc = "Description : ";
        String blank = "              ";
        System.out.println(desc + TrippiConsole.formatString(param.getLabel(), 79 - desc.length(), 79, desc.length()));
        if (param.getDescription() != null && !param.getDescription().equals("")) {
            System.out.println(blank + TrippiConsole.formatString(param.getDescription(), 79 - desc.length(), 79, desc.length()));
        }
        System.out.println("");
        List<String> options = param.getOptions();
        if (options.size() == 0) {
            boolean done = false;
            String input = null;
            while (!done) {
                System.out.print("Enter a value");
                if (param.isOptional()) {
                    System.out.print(" (or [ENTER] for none)");
                }
                System.out.print(": ");
                input = this.m_reader.readLine();
                if (input == null || input.equalsIgnoreCase("CANCEL")) {
                    return null;
                }
                if (input.equals("") && param.isOptional()) {
                    done = true;
                }
                if (input.equals("")) continue;
                done = true;
            }
            if (!input.equals("")) {
                map.put(param.getName(), input);
            }
        } else {
            HashMap<String, List<ConnectorParameter>> o = new HashMap<String, List<ConnectorParameter>>();
            Iterator<String> iter = options.iterator();
            StringBuffer optString = new StringBuffer();
            int i = 0;
            while (iter.hasNext()) {
                String val = iter.next();
                o.put(val, param.getParameters(val));
                if (++i == options.size()) {
                    optString.append(" or ");
                } else if (i > 1) {
                    optString.append(", ");
                }
                optString.append(val);
            }
            boolean done = false;
            String input = null;
            while (!done) {
                System.out.print("Enter " + optString);
                if (param.isOptional()) {
                    System.out.print(" (or [ENTER] for none)");
                }
                System.out.print(": ");
                input = this.m_reader.readLine();
                if (input == null || input.equalsIgnoreCase("CANCEL")) {
                    return null;
                }
                if (input.equals("") && param.isOptional()) {
                    done = true;
                    continue;
                }
                if (!o.containsKey(input)) continue;
                done = true;
            }
            if (!input.equals("")) {
                map.put(param.getName(), input);
                List subs = (List)o.get(input);
                if (subs != null) {
                    Map<String, String> subMap = this.configure(subs);
                    if (subMap == null) {
                        return null;
                    }
                    map.putAll(subMap);
                }
            }
        }
        return map;
    }

    public void doConnectors() throws Exception {
        Map<String, ConnectorDescriptor> m = ConnectorDescriptor.find();
        Iterator<String> iter = m.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (i > 0) {
                System.out.println("");
            }
            ++i;
            String className = iter.next();
            ConnectorDescriptor d = m.get(className);
            this.printConnectorInfo(d, className);
        }
    }

    private void printConnectorInfo(ConnectorDescriptor d, String className) {
        System.out.println("Connector   : " + d.getName());
        System.out.println("Class       : " + className);
        String desc = "Description : ";
        System.out.println(desc + TrippiConsole.formatString(d.getDescription(), 79 - desc.length(), 79, desc.length()));
    }

    public void doProfiles() throws TrippiException {
        Map<String, TrippiProfile> map = this.m_config.getProfiles();
        System.out.println("List of all known connection profiles (" + map.keySet().size() + "):");
        System.out.println("");
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            TrippiProfile p = map.get(iter.next());
            System.out.println(p.getId() + "\t" + p.getLabel());
        }
    }

    public void doUse(String profileId) throws Exception {
        TrippiProfile profile = this.m_config.getProfiles().get(profileId);
        if (profile == null) {
            throw new TrippiException("No such profile: '" + profileId + "'");
        }
        this.connect(profile);
    }

    public void doHelp() {
        System.out.println("List of all Trippi Console commands:");
        System.out.println("   (Commands must appear first on line and end with ';')");
        System.out.println("");
        System.out.println("add [triples] . . . . . . . Add one or more triples.");
        System.out.println("alias . . . . . . . . . . . List all alias values.");
        System.out.println("alias [name]  . . . . . . . List an alias value.");
        System.out.println("alias ! . . . . . . . . . . Clear all aliases.");
        System.out.println("alias [name] [val]  . . . . Assign an alias.");
        System.out.println("alias [name] !  . . . . . . Clear an alias.");
        System.out.println("count . . . . . . . . . . . Get the total number of triples.");
        System.out.println("count [triples] . . . . . . Get the number of triples returned by a query.");
        System.out.println("count [tuples]  . . . . . . Get the number of tuples returned by a query.");
        System.out.println("create  . . . . . . . . . . Create a new profile.");
        System.out.println("delete [triples] . .  . . . Delete one or more triples.");
        System.out.println("distinct . . . . . .  . . . Toggle forced distinct mode.");
        System.out.println("dump [file] . . . . . . . . Dump all triples to an RDF/XML file.");
        System.out.println("help  . . . . . . . . . . . Display this help.");
        System.out.println("close . . . . . . . . . . . Close the current connector.");
        System.out.println("connectors  . . . . . . . . List known triplestore connectors.");
        System.out.println("limit . . . . . . . . . . . Show current result limit (default = none)");
        System.out.println("limit [num] . . . . . . . . Set result limit ( 0 means none )");
        System.out.println("load [file] . . . . . . . . Load the RDF/XML file into the triplestore.");
        System.out.println("profiles  . . . . . . . . . List known profiles.");
        System.out.println("trace . . . . . . . . . . . Toggle stack trace printing for errors.");
        System.out.println("triples [pat] [lng] [qry] . Query for tuples.");
        System.out.println("triples [lng] [qry] . . . . Query for tuples.");
        System.out.println("tripleform  . . . . . . . . Show the current triple result format.");
        System.out.println("tripleform [newform]  . . . Switch to a new triple result format.");
        System.out.println("tupleform . . . . . . . . . Show the current tuple result format.");
        System.out.println("tupleform [newform]. .  . . Switch to a new tuple result format.");
        System.out.println("tuples [lng] [qry]  . . . . Query for tuples.");
        System.out.println("use [id]  . . . . . . . . . Use an existing profile.");
    }

    public static String formatString(String in, int firstMax, int otherMax, int otherIndent) {
        StringBuffer out = new StringBuffer();
        String[] tokens = in.split(" ");
        int charsLeft = firstMax;
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i++];
            out.append(token);
            if (i < tokens.length && tokens[i].length() >= (charsLeft -= token.length())) {
                out.append("\n" + TrippiConsole.indent(otherIndent));
                charsLeft = otherMax - otherIndent;
                continue;
            }
            out.append(' ');
            --charsLeft;
        }
        return out.toString();
    }

    public static String indent(int num) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            out.append(' ');
        }
        return out.toString();
    }
}

