/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class BlockingThreadPoolExecutorFactory {
    private static final int DEFAULT_CORE_POOL_SIZE = 10;
    private static final int DEFAULT_MAX_CORE_POOL_SIZE = 10;
    private static final int DEFAULT_WORK_QUEUE_SIZE = 10;
    private static final int DEFAULT_KEEP_ALIVE_TIME_MILLIS = 1000;
    private int corePoolSize = 10;
    private int maxPoolSize = 10;
    private long keepAliveTimeMillis = 1000L;
    private int workQueueSize = 10;

    public ThreadPoolExecutor newInstance() {
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        CallerRunsUnlessPoolShutdownPolicy rejectedExecutionHandler = new CallerRunsUnlessPoolShutdownPolicy();
        MyThreadFactory tf = new MyThreadFactory();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTimeMillis, TimeUnit.MILLISECONDS, workQueue, tf, rejectedExecutionHandler);
        return executor;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setKeepAliveTimeMillis(long keepAliveTimeMillis) {
        this.keepAliveTimeMillis = keepAliveTimeMillis;
    }

    public void setWorkQueueSize(int workQueueSize) {
        this.workQueueSize = workQueueSize;
    }

    private static final class MyThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private MyThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "core-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static final class CallerRunsUnlessPoolShutdownPolicy
    implements RejectedExecutionHandler {
        private CallerRunsUnlessPoolShutdownPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("Executor has been shut down.");
            }
            r.run();
        }
    }
}

