/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class IdentificationResultCollection {
    private long durationMillis;
    private Collection<IdentificationResult> results = new ArrayList<IdentificationResult>();
    private URI resourceUri;
    private Long fileLength;
    private Long correlationId;
    private long startTime;
    private boolean archive;
    private RequestMetaData requestMetaData;

    public IdentificationResultCollection(IdentificationRequest request) {
        this.correlationId = request.getIdentifier().getParentId();
        this.resourceUri = request.getIdentifier().getUri();
    }

    public void addResult(IdentificationResult result) {
        this.results.add(result);
    }

    public Collection<IdentificationResult> getResults() {
        return this.results;
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public Long getCorrelationId() {
        return this.correlationId;
    }

    public void setUri(URI uri) {
        this.resourceUri = uri;
    }

    public URI getUri() {
        return this.resourceUri;
    }

    public void setFileLength(Long fileLength) {
        this.fileLength = fileLength;
    }

    public Long getFileLength() {
        return this.fileLength;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        this.durationMillis = System.currentTimeMillis() - this.startTime;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public void setRequestMetaData(RequestMetaData requestMetaData) {
        this.requestMetaData = requestMetaData;
    }

    public RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }
}

