/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public final class ArchiveFileUtils {
    private static final String SSP_DELIMITER = ":/";
    private static final String ARCHIVE_DELIMITER = "!/";
    private static final int WRITE_BUFFER_CAPACITY = 8192;

    private ArchiveFileUtils() {
    }

    public static URI toZipUri(URI parent, String zipEntry) {
        try {
            return new URI("zip:" + parent + ARCHIVE_DELIMITER + new URI(null, FilenameUtils.separatorsToUnix((String)zipEntry), null));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URI toTarUri(URI parent, String tarEntry) {
        try {
            return new URI("tar:" + parent + ARCHIVE_DELIMITER + new URI(null, tarEntry, null));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeEntryToTemp(File tempDir, ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        File tempFile = File.createTempFile("droid-archive", null, tempDir);
        FileChannel out = new FileOutputStream(tempFile).getChannel();
        try {
            out.write(buffer);
            ByteBuffer buf = ByteBuffer.allocate(8192);
            buf.clear();
            while (channel.read(buf) >= 0 || buf.position() != 0) {
                buf.flip();
                out.write(buf);
                buf.compact();
            }
            File file = tempFile;
            return file;
        }
        finally {
            out.close();
        }
    }

    public static URI toGZipUri(URI parent) {
        try {
            return new URI("gz:" + parent + ARCHIVE_DELIMITER + new URI(null, GzipUtils.getUncompressedFilename((String)FilenameUtils.getName((String)parent.getSchemeSpecificPart())), null));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URI toReplayUri(URI requestUri) {
        String originSsp = StringUtils.substringBetween((String)requestUri.toString(), (String)SSP_DELIMITER, (String)"!");
        String scheme = StringUtils.substringBefore((String)requestUri.toString(), (String)SSP_DELIMITER);
        if (originSsp != null) {
            return URI.create(StringUtils.substringAfterLast((String)scheme, (String)":") + SSP_DELIMITER + originSsp);
        }
        return requestUri;
    }
}

