/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.collections.map.LazyMap;

class CachedBinary {
    private static final String ERROR_MESSAGE = "No byte at position [%s]";
    private Map<Long, ByteBuffer> cache;
    private RandomAccessFile raf;
    private int bufferCapacity;

    public CachedBinary(int blocks, int blockCapacity, ByteBuffer blockZero) {
        this.cache = LazyMap.decorate((Map)new LRUMap(blocks), (Transformer)new CacheTransformer());
        this.bufferCapacity = blockCapacity;
        blockZero.flip();
        this.cache.put(0L, blockZero);
    }

    void setRaf(RandomAccessFile file) {
        this.raf = file;
    }

    byte getByte(long position) {
        Long block = this.positionToBlock(position);
        ByteBuffer buffer = this.cache.get(block);
        try {
            return buffer.get((int)(position - block));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(String.format(ERROR_MESSAGE, position));
        }
    }

    private Long positionToBlock(long position) {
        return position / (long)this.bufferCapacity * (long)this.bufferCapacity;
    }

    void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    Map<Long, ByteBuffer> getBuffers() {
        return this.cache;
    }

    RandomAccessFile getRaf() {
        return this.raf;
    }

    public InputStream getSourceInputStream() throws IOException {
        InputStream in;
        if (this.raf == null) {
            ByteBuffer blockZero = this.cache.get(0L);
            byte[] bytes = new byte[blockZero.limit()];
            blockZero.get(bytes);
            in = new ByteArrayInputStream(bytes);
        } else {
            FileChannel channel = this.raf.getChannel();
            channel.position(0L);
            in = Channels.newInputStream(channel);
        }
        return in;
    }

    private final class CacheTransformer
    implements Transformer {
        private CacheTransformer() {
        }

        public Object transform(Object input) {
            Long block = (Long)input;
            try {
                ByteBuffer buffer = ByteBuffer.allocateDirect(CachedBinary.this.bufferCapacity);
                CachedBinary.this.raf.seek(block);
                CachedBinary.this.raf.getChannel().read(buffer);
                buffer.flip();
                return buffer;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

