/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.DefaultExtraField;
import de.schlichtherle.truezip.zip.UShort;
import de.schlichtherle.truezip.zip.ZipConstants;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
abstract class ExtraField {
    public static final int ZIP64_HEADER_ID = 1;
    private static final Map<Integer, Class<? extends ExtraField>> registry = new HashMap<Integer, Class<? extends ExtraField>>();

    ExtraField() {
    }

    public static void register(Class<? extends ExtraField> c) {
        ExtraField ef;
        try {
            ef = c.newInstance();
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        int headerID = ef.getHeaderID();
        UShort.check(headerID, "Header ID out of range", null);
        registry.put(headerID, c);
    }

    public static ExtraField create(int headerID) {
        ExtraField ef;
        UShort.check(headerID, "Header ID out of range", null);
        Class<? extends ExtraField> c = registry.get(headerID);
        try {
            ef = c != null ? c.newInstance() : new DefaultExtraField(headerID);
        }
        catch (Exception cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        assert (headerID == ef.getHeaderID());
        return ef;
    }

    public abstract int getHeaderID();

    abstract int getDataSize();

    final byte[] getDataBlock() {
        int size = this.getDataSize();
        UShort.check(size);
        if (size == 0) {
            return ZipConstants.EMPTY;
        }
        byte[] data = new byte[size];
        this.writeTo(data, 0);
        return data;
    }

    abstract void readFrom(byte[] var1, int var2, int var3);

    abstract void writeTo(byte[] var1, int var2);
}

