/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core;

import java.io.File;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.IdentificationRequestByteReaderAdapter;
import uk.gov.nationalarchives.droid.core.SignatureFileParser;
import uk.gov.nationalarchives.droid.core.interfaces.DroidCore;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.signature.droid4.FileFormatHit;
import uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile.FFSignatureFile;

public class Droid4LegacyDroid
implements DroidCore {
    private final Log log = LogFactory.getLog(this.getClass());
    private FFSignatureFile sigFile;
    private SignatureFileParser sigFileParser = new SignatureFileParser();
    private URI signatureFile;

    public void init() {
        this.sigFile = this.sigFileParser.parseSigFile(this.signatureFile.getPath());
        this.sigFile.prepareForUse();
    }

    public void setSignatureFile(String signatureFile) {
        this.signatureFile = new File(signatureFile).toURI();
    }

    public IdentificationResultCollection submit(IdentificationRequest request) {
        IdentificationResultCollection results = new IdentificationResultCollection(request);
        results.setRequestMetaData(request.getRequestMetaData());
        IdentificationRequestByteReaderAdapter byteReader = new IdentificationRequestByteReaderAdapter(request);
        this.sigFile.runFileIdentification(byteReader);
        results.start();
        for (int i = 0; i < byteReader.getNumHits(); ++i) {
            FileFormatHit hit = byteReader.getHit(i);
            IdentificationResultImpl result = new IdentificationResultImpl();
            result.setMimeType(hit.getMimeType());
            result.setName(hit.getFileFormatName());
            result.setPuid(hit.getFileFormatPUID());
            switch (hit.getHitType()) {
                case 11: {
                    result.setMethod(IdentificationMethod.BINARY_SIGNATURE);
                    break;
                }
                case 10: {
                    result.setMethod(IdentificationMethod.BINARY_SIGNATURE);
                    break;
                }
                case 12: {
                    result.setMethod(IdentificationMethod.EXTENSION);
                    break;
                }
                case 15: {
                    result.setMethod(IdentificationMethod.BINARY_SIGNATURE);
                    break;
                }
            }
            this.log.debug((Object)String.format("PUID = %s; name = %s; version = %s; type = %s", hit.getFileFormatPUID(), hit.getFileFormatName(), hit.getFileFormatVersion(), hit.getHitTypeVerbose()));
            results.addResult((IdentificationResult)result);
        }
        results.stop();
        results.setFileLength(Long.valueOf(request.size()));
        results.setRequestMetaData(request.getRequestMetaData());
        return results;
    }
}

