/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.AnalysisThread;
import uk.gov.nationalarchives.droid.core.signature.droid4.FileCollection;
import uk.gov.nationalarchives.droid.core.signature.droid4.FileFormatHit;
import uk.gov.nationalarchives.droid.core.signature.droid4.IdentificationFile;
import uk.gov.nationalarchives.droid.core.signature.droid4.MessageDisplay;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.AbstractByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile.FFSignatureFile;
import uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.droid4.xml.SAXModelBuilder;

public class AnalysisController {
    public static final String DROID_VERSION = "4.0";
    public static final int FILE_CLASSIFICATION_POSITIVE = 1;
    public static final int FILE_CLASSIFICATION_TENTATIVE = 2;
    public static final int FILE_CLASSIFICATION_NOHIT = 3;
    public static final int FILE_CLASSIFICATION_ERROR = 4;
    public static final int FILE_CLASSIFICATION_NOTCLASSIFIED = 5;
    public static final String FILE_CLASSIFICATION_POSITIVE_TEXT = "Positive";
    public static final String FILE_CLASSIFICATION_TENTATIVE_TEXT = "Tentative";
    public static final String FILE_CLASSIFICATION_NOHIT_TEXT = "Not identified";
    public static final String FILE_CLASSIFICATION_ERROR_TEXT = "Error";
    public static final String FILE_CLASSIFICATION_NOTCLASSIFIED_TEXT = "Not yet run";
    public static final int HIT_TYPE_POSITIVE_SPECIFIC = 10;
    public static final int HIT_TYPE_POSITIVE_GENERIC = 11;
    public static final int HIT_TYPE_TENTATIVE = 12;
    public static final int HIT_TYPE_POSITIVE_GENERIC_OR_SPECIFIC = 15;
    public static final String HIT_TYPE_POSITIVE_SPECIFIC_TEXT = "Positive (Specific Format)";
    public static final String HIT_TYPE_POSITIVE_GENERIC_TEXT = "Positive (Generic Format)";
    public static final String HIT_TYPE_TENTATIVE_TEXT = "Tentative";
    public static final String HIT_TYPE_POSITIVE_GENERIC_OR_SPECIFIC_TEXT = "Positive";
    public static final int FILE_BUFFER_SIZE = 100000000;
    public static final int CONFIG_DOWNLOAD_FREQ = 30;
    public static final String CONFIG_FILE_NAME = "DROID_config.xml";
    public static final String FILE_LIST_FILE_NAME = "DROID_filecollection.xml";
    public static final String PRONOM_WEB_SERVICE_URL = "http://www.nationalarchives.gov.uk/pronom/service.asmx";
    public static final String SIGNATURE_FILE_NAME = "DROID_SignatureFile.xml";
    public static final String PUID_RESOLUTION_URL = "http://www.nationalarchives.gov.uk/pronom/";
    public static final String BROWSER_PATH = "/usr/bin/firefox";
    public static final String LABEL_APPLICATION_VERSION = "DROIDVersion";
    public static final String LABEL_DATE_CREATED = "DateCreated";
    public static final String START_MODE_DROID = "Droid";
    public static final String PROFILE_REPORT_PATH = "reports";
    public static final String REPORT_TEMP_DIR = "tempDir";
    private static final String XML_DATE_FORMAT = "yyyy'-'MM'-'dd'T'HH:mm:ss";
    private static final String DISPLAY_DATE_FORMAT = "dd'-'MMM'-'yyyy";
    public static final String FILE_COLLECTION_NS = "http://www.nationalarchives.gov.uk/pronom/FileCollection";
    public static final String CONFIG_FILE_NS = "http://www.nationalarchives.gov.uk/pronom/ConfigFile";
    public static final String SIGNATURE_FILE_NS = "http://www.nationalarchives.gov.uk/pronom/SignatureFile";
    public List<String> formatName = new ArrayList<String>();
    public List<String> PUID = new ArrayList<String>();
    public List<String> mimeType = new ArrayList<String>();
    public List<String> version = new ArrayList<String>();
    public List<String> fileFormatDetail = new ArrayList<String>();
    public boolean isFileFormatPopulated = false;
    private FileCollection fileCollection = new FileCollection();
    private FFSignatureFile sigFile;
    private boolean analysisCancelled = false;
    private boolean verbose = true;
    private int numCompletedFiles = 0;
    private boolean isAnalysisRunning = false;
    private Date startTime;
    private Date completedTime;
    private static Log log = LogFactory.getLog(AnalysisController.class);
    private String outFormats = "";
    private String outFileName = "";
    private static ImageIcon dialogIcon = null;

    public AnalysisController() {
        try {
            dialogIcon = new ImageIcon(ImageIO.read(this.getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/DROID16.gif")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getFileFormatsDetails() {
        this.formatName = new ArrayList<String>();
        this.PUID = new ArrayList<String>();
        this.mimeType = new ArrayList<String>();
        this.fileFormatDetail = new ArrayList<String>();
        this.version = new ArrayList<String>();
        try {
            for (int i = 0; i < this.sigFile.getNumFileFormats(); ++i) {
                try {
                    FileFormat ff = this.sigFile.getFileFormat(i);
                    String strFormatName = ff.getName();
                    String strPUID = ff.getPUID();
                    String strMimeType = ff.getMimeType();
                    String strVersion = ff.getVersion();
                    String strFormatDetail = "";
                    if (strPUID != null) {
                        this.PUID.add(strPUID.trim());
                    }
                    if (strFormatDetail != null && !this.formatName.contains(strFormatName.trim())) {
                        this.formatName.add(strFormatName.trim());
                    }
                    if (!(strVersion == null || strVersion.equals("") || strVersion.equals("") || this.version.contains(strVersion.trim()))) {
                        this.version.add(strVersion.trim());
                    }
                    if (strMimeType == null || strMimeType.equals("") || this.mimeType.contains(strMimeType.trim())) continue;
                    this.mimeType.add(strMimeType.trim());
                    continue;
                }
                catch (Exception ex) {
                    System.out.println(ex.toString());
                }
            }
        }
        catch (Exception ex) {
            this.isFileFormatPopulated = false;
        }
        Collections.sort(this.PUID);
        Collections.sort(this.formatName);
        Collections.sort(this.mimeType);
        this.isFileFormatPopulated = true;
    }

    public static Date parseXMLDate(String XMLFormatDate) throws ParseException {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(XML_DATE_FORMAT);
        return xmlDateFormat.parse(XMLFormatDate);
    }

    public IdentificationFile performAnalysis(File diskfile) {
        IdentificationFile identificationFile = new IdentificationFile(diskfile.getAbsolutePath());
        ByteReader byteReader = AbstractByteReader.newByteReader(identificationFile);
        this.getSigFile().runFileIdentification(byteReader);
        return identificationFile;
    }

    public static String writeXMLDate(Date aDate) {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(XML_DATE_FORMAT);
        return xmlDateFormat.format(aDate);
    }

    public static String writeDisplayDate(Date aDate) {
        SimpleDateFormat displayDateFormat = new SimpleDateFormat(DISPLAY_DATE_FORMAT);
        return displayDateFormat.format(aDate);
    }

    private void debugDisplayBinFile(ByteReader testFile) {
        System.out.println("======================= " + testFile.getFileName());
        log.info((Object)("======================= " + testFile.getFileName()));
        String allTheBytes = "";
        for (int i = 0; i < 200; ++i) {
            allTheBytes = allTheBytes + this.showByte(testFile.getByte(i));
        }
        System.out.println(allTheBytes);
        log.debug((Object)allTheBytes);
    }

    private String showByte(byte theByte) {
        String byteDisplay = Integer.toHexString(theByte);
        if (byteDisplay.length() == 1) {
            byteDisplay = "0" + byteDisplay;
        }
        if (byteDisplay.length() > 2) {
            byteDisplay = byteDisplay.substring(byteDisplay.length() - 2);
        }
        return byteDisplay;
    }

    private static boolean isGUI(String[] args) {
        return args.length == 0;
    }

    private static boolean isCmdLine(String[] args) {
        return args.length > 0;
    }

    public void saveFileList(String filePath, boolean saveResults) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF8"));
            this.writeXmlWithElements(out, saveResults);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeXmlWithElements(BufferedWriter out, boolean saveResults) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.newLine();
        out.write("<FileCollection xmlns=\"http://www.nationalarchives.gov.uk/pronom/FileCollection\">");
        out.newLine();
        out.write("  <DROIDVersion>" + AnalysisController.getDROIDVersion().replaceAll("&", "&amp;") + "</DROIDVersion>");
        out.newLine();
        out.write("  <SignatureFileVersion>" + Integer.toString(this.getSigFileVersion()) + "</SignatureFileVersion>");
        out.newLine();
        out.write("  <DateCreated>" + AnalysisController.writeXMLDate(new Date()) + "</DateCreated>");
        out.newLine();
        Iterator<IdentificationFile> fileIterator = this.getFileIterator();
        while (fileIterator.hasNext()) {
            IdentificationFile idFile = fileIterator.next();
            out.write("  <IdentificationFile ");
            if (saveResults) {
                out.write("IdentQuality=\"" + idFile.getClassificationText() + "\" ");
            }
            out.write(">");
            out.newLine();
            out.write("    <FilePath>" + idFile.getFilePath().replaceAll("&", "&amp;") + "</FilePath>");
            out.newLine();
            if (saveResults && !"".equals(idFile.getWarning())) {
                out.write("    <Warning>" + idFile.getWarning().replaceAll("&", "&amp;") + "</Warning>");
                out.newLine();
            }
            if (saveResults) {
                for (int hitCounter = 0; hitCounter < idFile.getNumHits(); ++hitCounter) {
                    FileFormatHit formatHit = idFile.getHit(hitCounter);
                    out.write("    <FileFormatHit>");
                    out.newLine();
                    out.write("      <Status>" + formatHit.getHitTypeVerbose() + "</Status>");
                    out.newLine();
                    out.write("      <Name>" + formatHit.getFileFormatName().replaceAll("&", "&amp;") + "</Name>");
                    out.newLine();
                    if (formatHit.getFileFormatVersion() != null) {
                        out.write("      <Version>" + formatHit.getFileFormatVersion().replaceAll("&", "&amp;") + "</Version>");
                        out.newLine();
                    }
                    if (formatHit.getFileFormatPUID() != null) {
                        out.write("      <PUID>" + formatHit.getFileFormatPUID().replaceAll("&", "&amp;") + "</PUID>");
                        out.newLine();
                    }
                    if (formatHit.getMimeType() != null) {
                        out.write("      <MimeType>" + formatHit.getMimeType().replaceAll("&", "&amp;") + "</MimeType>");
                        out.newLine();
                    }
                    if (!"".equals(formatHit.getHitWarning())) {
                        out.write("      <IdentificationWarning>" + formatHit.getHitWarning().replaceAll("&", "&amp;") + "</IdentificationWarning>");
                        out.newLine();
                    }
                    out.write("    </FileFormatHit>");
                    out.newLine();
                }
            }
            out.write("  </IdentificationFile>");
            out.newLine();
        }
        out.write("</FileCollection>");
        out.newLine();
        out.flush();
        out.close();
    }

    public void exportFileCollectionAsCSV(String filePath) {
        StringBuffer fileText = new StringBuffer();
        fileText.append("DROID Version,\"").append(AnalysisController.getDROIDVersion()).append("\"");
        fileText.append(",,SigFile Version,\"").append(this.getSigFileVersion()).append("\"");
        fileText.append(",,Date Created,\"").append(AnalysisController.writeDisplayDate(new Date())).append("\"");
        fileText.append("\n");
        fileText.append("Status,File,Warning,PUID,MIME,Format,Version,Status,Warning\n");
        Iterator<IdentificationFile> fileIterator = this.getFileIterator();
        while (fileIterator.hasNext()) {
            IdentificationFile idFile = fileIterator.next();
            fileText.append("\"").append(idFile.getClassificationText()).append("\"");
            fileText.append(",");
            fileText.append("\"").append(idFile.getFilePath()).append("\"");
            fileText.append(",");
            fileText.append("\"").append(idFile.getWarning()).append("\"");
            fileText.append("\n");
            for (int hitCounter = 0; hitCounter < idFile.getNumHits(); ++hitCounter) {
                FileFormatHit hit = idFile.getHit(hitCounter);
                fileText.append(",,,");
                fileText.append("\"").append(hit.getFileFormatPUID()).append("\"");
                fileText.append(",");
                fileText.append("\"").append(hit.getMimeType()).append("\"");
                fileText.append(",");
                fileText.append("\"").append(hit.getFileFormatName()).append("\"");
                fileText.append(",");
                fileText.append("\"").append(hit.getFileFormatVersion()).append("\"");
                fileText.append(",");
                fileText.append("\"").append(hit.getHitTypeVerbose()).append("\"");
                fileText.append(",");
                fileText.append("\"").append(hit.getHitWarning()).append("\"");
                fileText.append("\n");
            }
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filePath));
            out.write(fileText.toString());
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void readFileCollection() throws Exception {
        this.readFileCollection(FILE_LIST_FILE_NAME);
    }

    public boolean readFileCollection(String theFileName) {
        try {
            this.checkFile(theFileName);
            MessageDisplay.resetXMLRead();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            SAXModelBuilder mb = new SAXModelBuilder();
            mb.setObjectPackage("uk.gov.nationalarchives.droid");
            mb.setupNamespace(FILE_COLLECTION_NS, true);
            parser.setContentHandler(mb);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(theFileName), "UTF8"));
            parser.parse(new InputSource(in));
            this.fileCollection = (FileCollection)mb.getModel();
            if (this.fileCollection == null) {
                throw new Exception("The file " + theFileName + " doesn't specify any files.");
            }
            this.fileCollection.setFileName(theFileName);
            String successMessage = "The XML file " + theFileName;
            int numXMLWarnings = MessageDisplay.getNumXMLWarnings();
            successMessage = numXMLWarnings == 0 ? successMessage + " was successfully loaded" : (numXMLWarnings == 1 ? successMessage + " was loaded with 1 warning" : successMessage + " was loaded with " + numXMLWarnings + " warnings");
            int numLoadedFiles = this.fileCollection.getNumFiles();
            successMessage = numLoadedFiles == 0 ? successMessage + "\nNo files were read in" : (numLoadedFiles == 1 ? successMessage + "\n1 file was read in" : successMessage + "\n" + numLoadedFiles + " files were read in");
            MessageDisplay.generalInformation(successMessage);
            int theFileSigFileVersion = this.fileCollection.getLoadedFileSigFileVersion();
            int theCurrentSigFileVersion = this.getSigFileVersion();
            if (theFileSigFileVersion > 0 && theCurrentSigFileVersion != theFileSigFileVersion) {
                MessageDisplay.generalWarning("The file was generated with signature file V" + theFileSigFileVersion + ".  The current signature file is V" + theCurrentSigFileVersion);
            }
            return true;
        }
        catch (Exception e) {
            MessageDisplay.generalWarning(e.toString());
            this.fileCollection = null;
            log.error((Object)("An error occured in loading this list, it is likely that the file (\"" + theFileName + "\")\n is not a valid DROID list .xml file"));
            return false;
        }
    }

    public String readSigFile(String theSigFileName) throws Exception {
        this.readSigFile(theSigFileName, true);
        return this.sigFile.getVersion();
    }

    public void readSigFile(String theSigFileName, boolean isConfigSave) throws Exception {
        this.readSigFile(theSigFileName, isConfigSave, false);
    }

    public String readSigFile(URL theSigFileURL) throws Exception {
        this.sigFile = this.parseSigFile(theSigFileURL);
        this.sigFile.prepareForUse();
        return this.sigFile.getVersion();
    }

    public void readSigFile(String theSigFileName, boolean isConfigSave, boolean hideWarning) throws Exception {
        try {
            this.checkFile(theSigFileName);
            MessageDisplay.resetXMLRead();
            this.sigFile = this.parseSigFile(theSigFileName);
            this.sigFile.prepareForUse();
            String theVersion = this.sigFile.getVersion();
            MessageDisplay.setStatusText("Current signature file is V" + this.getSigFileVersion(), "Signature file V" + this.getSigFileVersion() + " has been checked");
            int numXMLWarnings = MessageDisplay.getNumXMLWarnings();
            if (numXMLWarnings > 0) {
                String successMessage = "The signature file " + theSigFileName + " was loaded with " + numXMLWarnings + " warnings";
                String cmdlineMessage = numXMLWarnings + " warnings were found";
                MessageDisplay.generalInformation(successMessage, cmdlineMessage);
            }
        }
        catch (Exception e) {
            if (!hideWarning) {
                MessageDisplay.generalWarning(e.toString());
            }
            this.sigFile = null;
        }
    }

    private XMLReader getXMLReader(SAXModelBuilder mb) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        XMLReader parser = saxParser.getXMLReader();
        mb.setupNamespace(SIGNATURE_FILE_NS, true);
        parser.setContentHandler(mb);
        return parser;
    }

    public FFSignatureFile parseSigFile(URL signatureFileURL) throws Exception {
        SAXModelBuilder mb = new SAXModelBuilder();
        XMLReader parser = this.getXMLReader(mb);
        BufferedReader in = new BufferedReader(new InputStreamReader(signatureFileURL.openStream(), "UTF8"));
        parser.parse(new InputSource(in));
        return (FFSignatureFile)mb.getModel();
    }

    public FFSignatureFile parseSigFile(String theFileName) throws Exception {
        SAXModelBuilder mb = new SAXModelBuilder();
        XMLReader parser = this.getXMLReader(mb);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(theFileName), "UTF8"));
        parser.parse(new InputSource(in));
        return (FFSignatureFile)mb.getModel();
    }

    private void checkFile(String theFileName) throws Exception {
        File file = new File(theFileName);
        if (!file.exists()) {
            throw new Exception("The file " + theFileName + " does not exist");
        }
        if (!file.canRead()) {
            throw new Exception("The file " + theFileName + " cannot be read");
        }
        if (file.isDirectory()) {
            throw new Exception("The file " + theFileName + " is a directory");
        }
    }

    public boolean isFileFound(String theFileName) {
        File file = new File(theFileName);
        return file.exists();
    }

    public void resetFileList() {
        this.fileCollection.removeAll();
    }

    public void addFile(String fileFolderName) {
        this.addFile(fileFolderName, false);
    }

    public void addFile(String fileFolderName, boolean isRecursive) {
        this.fileCollection.addFile(fileFolderName, isRecursive);
    }

    public void removeFile(String theFileName) {
        this.fileCollection.removeFile(theFileName);
    }

    public void removeFile(int theIndex) {
        this.fileCollection.removeFile(theIndex);
    }

    public IdentificationFile getFile(int theIndex) {
        IdentificationFile theFile = null;
        try {
            theFile = this.fileCollection.getFile(theIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theFile;
    }

    public int getNumFiles() {
        int theNumFiles = 0;
        try {
            theNumFiles = this.fileCollection.getNumFiles();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theNumFiles;
    }

    public Iterator<IdentificationFile> getFileIterator() {
        return this.fileCollection.getIterator();
    }

    public int getSigFileVersion() {
        int theVersion = 0;
        try {
            theVersion = Integer.parseInt(this.sigFile.getVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theVersion;
    }

    public FFSignatureFile getSigFile() {
        return this.sigFile;
    }

    public static String getDROIDVersion() {
        String theVersion = DROID_VERSION;
        int theLastDot = theVersion.lastIndexOf(".");
        if (theLastDot > -1 && theVersion.indexOf(".") < theLastDot) {
            theVersion = theVersion.substring(0, theLastDot);
        }
        return theVersion;
    }

    public int getNumCompletedFiles() {
        if (this.isAnalysisRunning) {
            return this.numCompletedFiles;
        }
        int theNumCompletedFiles = 0;
        Iterator<IdentificationFile> files = this.fileCollection.getIterator();
        while (files.hasNext()) {
            if (!files.next().isClassified()) continue;
            ++theNumCompletedFiles;
        }
        return theNumCompletedFiles;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getCompletedTime() {
        return this.completedTime;
    }

    public void setAnalysisComplete() {
        this.isAnalysisRunning = false;
        this.completedTime = new Date();
        if (this.outFormats.indexOf("XML") > -1 || this.outFormats.indexOf("xml") > -1) {
            this.saveFileList(this.outFileName + ".xml", true);
        }
        if (this.outFormats.indexOf("CSV") > -1 || this.outFormats.indexOf("csv") > -1) {
            this.exportFileCollectionAsCSV(this.outFileName + ".csv");
        }
    }

    public void setProfilingComplete() {
        this.isAnalysisRunning = false;
        this.completedTime = new Date();
    }

    public boolean isAnalysisComplete() {
        return !this.isAnalysisRunning;
    }

    public void setAnalysisStart() {
        this.numCompletedFiles = 0;
        this.isAnalysisRunning = true;
        this.analysisCancelled = false;
        this.startTime = new Date();
    }

    public void incrNumCompletedFile() {
        ++this.numCompletedFiles;
    }

    public boolean isAnalysisCancelled() {
        return this.analysisCancelled;
    }

    public void setCancelAnalysis(boolean cancelledAnalysis) {
        this.analysisCancelled = cancelledAnalysis;
    }

    public void runFileFormatAnalysis() {
        this.analysisCancelled = false;
        this.outFileName = "";
        this.outFormats = "";
        new AnalysisThread(this.fileCollection, this.sigFile, this).start();
    }

    public void runFileFormatAnalysis(String theOutFormats, String theOutFileName) {
        this.analysisCancelled = false;
        this.outFileName = theOutFileName;
        this.outFormats = theOutFormats;
        new AnalysisThread(this.fileCollection, this.sigFile, this).start();
    }

    public FileCollection getFileCollection() {
        return this.fileCollection;
    }

    public String getSignatureFileDate() {
        String theDate = "";
        try {
            theDate = this.sigFile.getDateCreated();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (theDate.equals("")) {
            theDate = "No date given";
        }
        return theDate;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

