/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import uk.gov.nationalarchives.droid.core.signature.droid4.FileFormatHit;
import uk.gov.nationalarchives.droid.core.signature.droid4.MessageDisplay;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.InputStreamByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.UrlByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.xml.SimpleElement;

public class IdentificationFile
extends SimpleElement
implements Comparable {
    private String identificationWarning = "";
    private int myIDStatus = 5;
    private List<FileFormatHit> fileHits = new ArrayList<FileFormatHit>();
    private String filePath;

    public IdentificationFile(String filePath) {
        this.setFilePath(filePath);
    }

    public IdentificationFile() {
    }

    public void setIDStatus(int theStatus) {
        this.myIDStatus = theStatus;
    }

    public void setPositiveIdent() {
        this.myIDStatus = 1;
    }

    public void setTentativeIdent() {
        this.myIDStatus = 2;
    }

    public void setNoIdent() {
        this.myIDStatus = 3;
    }

    public void setErrorIdent() {
        this.myIDStatus = 4;
    }

    public void setWarning(String warning) {
        this.identificationWarning = warning;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void addHit(FileFormatHit hit) {
        this.fileHits.add(hit);
    }

    public void addFileFormatHit(FileFormatHit theHit) {
        this.fileHits.add(theHit);
    }

    public void removeHit(int index) {
        this.fileHits.remove(index);
    }

    public String getFileName() {
        if (InputStreamByteReader.isInputStream(this.filePath)) {
            return "";
        }
        if (UrlByteReader.isURL(this.filePath)) {
            return UrlByteReader.getURL(this.filePath).getFile();
        }
        return new File(this.filePath).getName();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean isClassified() {
        return this.myIDStatus != 5;
    }

    public int getClassification() {
        return this.myIDStatus;
    }

    public String getClassificationText() {
        String theClassificationText = "";
        if (this.myIDStatus == 1) {
            theClassificationText = "Positive";
        } else if (this.myIDStatus == 2) {
            theClassificationText = "Tentative";
        } else if (this.myIDStatus == 3) {
            theClassificationText = "Not identified";
        } else if (this.myIDStatus == 4) {
            theClassificationText = "Error";
        } else if (this.myIDStatus == 5) {
            theClassificationText = "Not yet run";
        }
        return theClassificationText;
    }

    public String getWarning() {
        return this.identificationWarning;
    }

    public int getNumHits() {
        return this.fileHits.size();
    }

    public FileFormatHit getHit(int theIndex) {
        return this.fileHits.get(theIndex);
    }

    @Override
    public void setAttributeValue(String theName, String theValue) {
        if (theName.equals("Name")) {
            this.setFilePath(theValue);
        } else if (theName.equals("IdentQuality")) {
            if (theValue.equals("Positive")) {
                this.myIDStatus = 1;
            } else if (theValue.equals("Tentative")) {
                this.myIDStatus = 2;
            } else if (theValue.equals("Not identified")) {
                this.myIDStatus = 3;
            } else if (theValue.equals("Error")) {
                this.myIDStatus = 4;
            } else if (theValue.equals("Not yet run")) {
                this.myIDStatus = 5;
            } else {
                MessageDisplay.generalWarning("Unknown file status listed: <" + theValue + "> is not the same as <" + "Positive" + ">");
            }
        } else if (theName.equals("Warning")) {
            this.setWarning(theValue);
        } else {
            MessageDisplay.unknownAttributeWarning(theName, this.getElementName());
        }
    }

    public int compareTo(Object otherIDFile) {
        if (this.filePath == null || this.filePath.length() == 0) {
            return -1;
        }
        return this.getFilePath().compareToIgnoreCase(((IdentificationFile)otherIDFile).getFilePath());
    }

    public boolean equals(Object otherIDFile) {
        return otherIDFile instanceof IdentificationFile && this.filePath.toLowerCase().equals(((IdentificationFile)otherIDFile).filePath.toLowerCase());
    }

    public int hashCode() {
        if (this.filePath == null || this.filePath.length() == 0) {
            return super.hashCode();
        }
        return this.filePath.toLowerCase().hashCode();
    }
}

