/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MessageDisplay {
    public static String FILEEXTENSIONWARNING = "Possible file extension mismatch";
    public static String POSITIVEIDENTIFICATIONSTATUS = "Positively identified";
    public static String TENTATIVEIDENTIFICATIONSTATUS = "Tentatively identified";
    public static String UNIDENTIFIEDSTATUS = "Unable to identify";
    private static JFrame myMainPane = null;
    private static JDialog statusResultsDialog = null;
    private static boolean isGUIdisplay = false;
    private static boolean hideXMLWarnings = false;
    private static int numXMLWarnings = 0;
    private static Log log = LogFactory.getLog(MessageDisplay.class);

    public static void unknownElementWarning(String unknownElement, String containerElement) {
        String theCMDMessage = "WARNING: Unknown XML element " + unknownElement + " found under " + containerElement + " ";
        String theGUIMessage = theCMDMessage + "\nDo you wish to hide any further XML reading errors for this file?";
        ++numXMLWarnings;
        if (isGUIdisplay) {
            if (!hideXMLWarnings) {
                hideXMLWarnings = JOptionPane.showConfirmDialog(myMainPane, theGUIMessage, "DROID warning", 0, 2) == 0;
            }
        } else {
            System.out.println(theCMDMessage);
            log.info((Object)theCMDMessage);
        }
    }

    public static void unknownAttributeWarning(String unknownAttribute, String containerElement) {
        String theCMDMessage = "WARNING: Unknown XML attribute " + unknownAttribute + " found for " + containerElement + " ";
        String theGUIMessage = theCMDMessage + "\nDo you wish to hide any further XML reading errors for this file?";
        ++numXMLWarnings;
        if (isGUIdisplay) {
            if (!hideXMLWarnings) {
                hideXMLWarnings = JOptionPane.showConfirmDialog(myMainPane, theGUIMessage, "DROID warning", 0, 2) == 0;
            }
        } else {
            System.out.println(theCMDMessage);
            log.info((Object)theCMDMessage);
        }
    }

    public static void generalWarning(String theWarning) {
        String theMessage = "WARNING: " + theWarning.replaceFirst("java.lang.Exception: ", "");
        if (isGUIdisplay) {
            JOptionPane.showMessageDialog(myMainPane, theMessage, "DROID warning", 2);
        } else {
            System.out.println(theMessage);
            log.info((Object)theMessage);
        }
    }

    public static void generalInformation(String theMessage) {
        if (isGUIdisplay) {
            JOptionPane.showMessageDialog(myMainPane, theMessage, "DROID information", 1);
        } else {
            System.out.println(theMessage);
            log.info((Object)theMessage);
        }
    }

    public static void generalInformation(String theGUIMessage, String theCMDMessage) {
        if (isGUIdisplay) {
            JOptionPane.showMessageDialog(myMainPane, theGUIMessage, "DROID information", 1);
        } else {
            System.out.println(theCMDMessage);
            log.info((Object)theCMDMessage);
        }
    }

    public static void setStatusText(String theMessage) {
        if (isGUIdisplay) {
            if (myMainPane.getClass().getName().equalsIgnoreCase("uk.gov.nationalarchives.droid.GUI.FileIdentificationPane")) {
                JPanel jPanelStatusBar = (JPanel)myMainPane.getContentPane().getComponents()[2];
                JLabel jStatus = (JLabel)jPanelStatusBar.getComponents()[0];
                jStatus.setText(theMessage);
            }
            JOptionPane.showMessageDialog(myMainPane, theMessage, "uk information", 1);
        } else {
            System.out.println(theMessage);
            log.info((Object)theMessage);
        }
    }

    public static void setStatusText(String theGUIMessage, String theCMDMessage) {
        if (isGUIdisplay) {
            if (myMainPane.getClass().getName().equalsIgnoreCase("uk.gov.nationalarchives.droid.GUI.FileIdentificationPane")) {
                JPanel jPanelStatusBar = (JPanel)myMainPane.getContentPane().getComponents()[2];
                JLabel jStatus = (JLabel)jPanelStatusBar.getComponents()[0];
                jStatus.setText(theGUIMessage);
            }
        } else {
            System.out.println(theCMDMessage);
            log.info((Object)theCMDMessage);
        }
    }

    public static void generalError(String theWarning) throws Exception {
        String theMessage = "Error: " + theWarning;
        if (isGUIdisplay) {
            JOptionPane.showMessageDialog(myMainPane, theMessage, "DROID error", 0);
        } else {
            System.out.println(theMessage);
            log.error((Object)theMessage);
        }
        throw new Exception(theWarning);
    }

    public static void generalErrorjDialog(String theWarning) throws Exception {
        String theMessage = "Error: " + theWarning;
        JOptionPane.showMessageDialog(statusResultsDialog, theMessage, "DROID error", 0);
    }

    public static void fatalError(String theWarning) {
        String theMessage = "Fatal Error: " + theWarning;
        if (isGUIdisplay) {
            JOptionPane.showMessageDialog(myMainPane, theMessage, "DROID fatal error", 0);
        } else {
            System.out.println(theMessage);
            log.fatal((Object)theMessage);
        }
        System.exit(0);
    }

    public static int getNumXMLWarnings() {
        return numXMLWarnings;
    }

    public static void resetXMLRead() {
        numXMLWarnings = 0;
        hideXMLWarnings = false;
    }

    public static void initialiseMainPane(JDialog statusDialog) {
        statusResultsDialog = statusDialog;
    }

    public static void initialiseMainPane(JFrame theMainPane) {
        myMainPane = theMainPane;
        isGUIdisplay = true;
    }

    public static boolean exitDueToMissigSigFile() {
        if (isGUIdisplay) {
            return JOptionPane.showConfirmDialog(myMainPane, "Signature file was not found.\nDo you wish to download a new one from PRONOM web service?\nSelecting NO will exit the application.", "Signature file not found", 0, 3) != 0;
        }
        System.out.println("Signature file not loaded");
        log.error((Object)"Signature file not loaded");
        return true;
    }
}

