/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4.bytereader;

import uk.gov.nationalarchives.droid.core.signature.droid4.FileFormatHit;
import uk.gov.nationalarchives.droid.core.signature.droid4.IdentificationFile;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.FileByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.InputStreamByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.UrlByteReader;

public abstract class AbstractByteReader
implements ByteReader {
    protected IdentificationFile myIDFile;

    protected AbstractByteReader(IdentificationFile theIDFile) {
        this.myIDFile = theIDFile;
    }

    public static ByteReader newByteReader(IdentificationFile theIDFile) {
        return AbstractByteReader.newByteReader(theIDFile, true);
    }

    public static ByteReader newByteReader(IdentificationFile theIDFile, boolean readFile) {
        if (InputStreamByteReader.isInputStream(theIDFile.getFilePath())) {
            return InputStreamByteReader.newInputStreamByteReader(theIDFile, readFile);
        }
        if (UrlByteReader.isURL(theIDFile.getFilePath())) {
            return UrlByteReader.newUrlByteReader(theIDFile, readFile);
        }
        return new FileByteReader(theIDFile, readFile);
    }

    @Override
    public void setPositiveIdent() {
        this.myIDFile.setPositiveIdent();
    }

    @Override
    public void setTentativeIdent() {
        this.myIDFile.setTentativeIdent();
    }

    @Override
    public void setNoIdent() {
        this.myIDFile.setNoIdent();
    }

    @Override
    public void setErrorIdent() {
        this.myIDFile.setErrorIdent();
    }

    @Override
    public boolean isClassified() {
        return this.myIDFile.isClassified();
    }

    @Override
    public int getClassification() {
        return this.myIDFile.getClassification();
    }

    @Override
    public void setIdentificationWarning(String theWarning) {
        this.myIDFile.setWarning(theWarning);
    }

    @Override
    public String getIdentificationWarning() {
        return this.myIDFile.getWarning();
    }

    @Override
    public void addHit(FileFormatHit theHit) {
        this.myIDFile.addHit(theHit);
    }

    @Override
    public void removeHit(int theIndex) {
        this.myIDFile.removeHit(theIndex);
    }

    @Override
    public int getNumHits() {
        return this.myIDFile.getNumHits();
    }

    @Override
    public FileFormatHit getHit(int theIndex) {
        return this.myIDFile.getHit(theIndex);
    }

    @Override
    public String getFilePath() {
        return this.myIDFile.getFilePath();
    }

    @Override
    public String getFileName() {
        return this.myIDFile.getFileName();
    }

    @Override
    public void close() {
    }
}

