/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4.bytereader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import uk.gov.nationalarchives.droid.core.signature.droid4.IdentificationFile;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.AbstractByteReader;

public class StreamByteReader
extends AbstractByteReader {
    private static final int BUFFER_SIZE = 131072;
    protected ByteBuffer buffer = null;
    protected File tempFile = null;

    protected StreamByteReader(IdentificationFile theIDFile) {
        super(theIDFile);
    }

    protected void readStream(InputStream inStream) throws IOException {
        ReadableByteChannel c = Channels.newChannel(inStream);
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(131072);
        } else {
            this.buffer.clear();
        }
        int bytes = 0;
        while (bytes >= 0 && this.buffer.hasRemaining()) {
            bytes = c.read(this.buffer);
        }
        this.buffer.flip();
        if (this.buffer.limit() == 0) {
            this.setErrorIdent();
            this.setIdentificationWarning("Zero-length file");
            return;
        }
        if (bytes != -1) {
            this.tempFile = StreamByteReader.writeToTempFile(this.buffer, c);
        }
    }

    static File writeToTempFile(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        File tempFile = File.createTempFile("droid", null);
        FileChannel fc = new FileOutputStream(tempFile).getChannel();
        ByteBuffer buf = ByteBuffer.allocate(8192);
        fc.write(buffer);
        buf.clear();
        while (channel.read(buf) >= 0) {
            buf.flip();
            fc.write(buf);
            buf.compact();
        }
        fc.close();
        return tempFile;
    }

    @Override
    public byte getByte(long fileIndex) {
        return this.buffer.get((int)fileIndex);
    }

    @Override
    public long getFileMarker() {
        return this.buffer.position();
    }

    @Override
    public long getNumBytes() {
        return this.buffer == null ? 0L : (long)this.buffer.limit();
    }

    @Override
    public void setFileMarker(long markerPosition) {
        this.buffer.position((int)markerPosition);
    }

    @Override
    public byte[] getbuffer() {
        return this.buffer.array();
    }
}

