/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4.bytereader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import uk.gov.nationalarchives.droid.core.signature.droid4.IdentificationFile;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.FileByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.StreamByteReader;

public class UrlByteReader
extends StreamByteReader {
    private UrlByteReader(IdentificationFile theIDFile, boolean readFile) {
        super(theIDFile);
        if (readFile) {
            this.readUrl();
        }
    }

    static ByteReader newUrlByteReader(IdentificationFile theIDFile, boolean readFile) {
        UrlByteReader byteReader = new UrlByteReader(theIDFile, readFile);
        if (byteReader.tempFile == null) {
            return byteReader;
        }
        return new FileByteReader(theIDFile, readFile, byteReader.tempFile.getPath());
    }

    private void readUrl() {
        URL url;
        try {
            url = new URL(this.myIDFile.getFilePath());
        }
        catch (MalformedURLException ex) {
            this.setErrorIdent();
            this.setIdentificationWarning("URL is malformed");
            return;
        }
        try {
            this.readStream(url.openStream());
        }
        catch (IOException ex) {
            this.setErrorIdent();
            this.setIdentificationWarning("URL could not be read");
        }
    }

    public static URL getURL(String path) {
        URL url = null;
        try {
            url = new URL(path);
            if (url.getProtocol().equalsIgnoreCase("http")) {
                return url;
            }
            return null;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static boolean isURL(String path) {
        URL url = null;
        try {
            url = new URL(path);
            if (url.getProtocol().equalsIgnoreCase("http")) {
                return true;
            }
        }
        catch (MalformedURLException ex) {
            return false;
        }
        return false;
    }
}

