/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile;

import java.util.ArrayList;
import java.util.List;
import uk.gov.nationalarchives.droid.core.signature.droid4.MessageDisplay;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile.SubSequence;
import uk.gov.nationalarchives.droid.core.signature.droid4.xml.SimpleElement;

public class ByteSequence
extends SimpleElement {
    int parentSignature;
    List<SubSequence> subSequences = new ArrayList<SubSequence>();
    String reference = "";
    boolean bigEndian = true;
    int indirectOffsetLength = 0;
    int indirectOffsetLocation = 0;

    public int getIndirectOffsetLength() {
        return this.indirectOffsetLength;
    }

    public int getIndirectOffsetLocation() {
        return this.indirectOffsetLocation;
    }

    public int getParentSignature() {
        return this.parentSignature;
    }

    public void setParentSignature(int parentSignature) {
        this.parentSignature = parentSignature;
    }

    public void addSubSequence(SubSequence sseq) {
        this.subSequences.add(sseq);
    }

    public void setSubSequences(List<SubSequence> SubSequences) {
        this.subSequences = SubSequences;
    }

    public void setReference(String theRef) {
        this.reference = theRef;
    }

    public void setEndianness(String endianness) {
        this.bigEndian = !endianness.equals("Little-endian");
    }

    public void setIndirectOffsetLength(String indirectOffsetLength) {
        this.indirectOffsetLength = Integer.parseInt(indirectOffsetLength);
    }

    public void setIndirectOffsetLocation(String indirectOffsetLocation) {
        this.indirectOffsetLocation = Integer.parseInt(indirectOffsetLocation);
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    @Override
    public void setAttributeValue(String name, String value) {
        if (name.equals("Reference")) {
            this.setReference(value);
        } else if (name.equals("Endianness")) {
            this.setEndianness(value);
        } else if (name.equals("IndirectOffsetLength")) {
            this.setIndirectOffsetLength(value);
        } else if (name.equals("IndirectOffsetLocation")) {
            this.setIndirectOffsetLocation(value);
        } else {
            MessageDisplay.unknownAttributeWarning(name, this.getElementName());
        }
    }

    public boolean isAnchored() {
        return this.getReference().endsWith("EOFoffset") || this.getReference().endsWith("BOFoffset");
    }

    public List getSubSequences() {
        return this.subSequences;
    }

    public int getNumSubSequences() {
        return this.subSequences.size();
    }

    public SubSequence getSubSequence(int theIndex) {
        return this.subSequences.get(theIndex);
    }

    public String getReference() {
        return this.reference;
    }

    public boolean isFileCompliant(ByteReader targetFile) {
        int searchDirection;
        boolean isCompliant = true;
        boolean reverseOrder = this.getReference().equalsIgnoreCase("EOFoffset");
        int ssLoopStart = reverseOrder ? this.getNumSubSequences() - 1 : 0;
        int ssLoopEnd = reverseOrder ? -1 : this.getNumSubSequences();
        int n = searchDirection = reverseOrder ? -1 : 1;
        if (reverseOrder) {
            targetFile.setFileMarker(targetFile.getNumBytes() - 1L);
        } else {
            targetFile.setFileMarker(0L);
        }
        int iSS = ssLoopStart;
        while (searchDirection * iSS < searchDirection * ssLoopEnd & isCompliant) {
            boolean isFixedStart = this.getReference().endsWith("EOFoffset") || this.getReference().endsWith("BOFoffset");
            isCompliant = iSS == ssLoopStart && isFixedStart ? this.getSubSequence(iSS).isFoundAtStartOfFile(targetFile, reverseOrder, this.bigEndian) : this.getSubSequence(iSS).isFoundAfterFileMarker(targetFile, reverseOrder, this.bigEndian);
            iSS += searchDirection;
        }
        return isCompliant;
    }

    public String toString() {
        return this.reference + "{" + this.subSequences + "}";
    }
}

