/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile;

import uk.gov.nationalarchives.droid.core.signature.droid4.MessageDisplay;
import uk.gov.nationalarchives.droid.core.signature.droid4.xml.SimpleElement;

public class Shift
extends SimpleElement {
    long myShiftValue;
    int myShiftByte = 999;

    @Override
    public void completeElementContent() {
        String theElementValue = this.getText();
        try {
            this.myShiftValue = Long.parseLong(theElementValue);
        }
        catch (Exception e) {
            MessageDisplay.generalWarning("The following non-numerical shift distance was found in the signature file: " + theElementValue);
            this.myShiftValue = 1L;
        }
    }

    @Override
    public void setAttributeValue(String theName, String theValue) {
        if (theName.equals("Byte")) {
            try {
                this.myShiftByte = Integer.parseInt(theValue, 16);
            }
            catch (Exception exception) {}
        } else {
            MessageDisplay.unknownAttributeWarning(theName, this.getElementName());
        }
    }

    public int getShiftByte() {
        return this.myShiftByte;
    }

    public long getShiftValue() {
        return this.myShiftValue;
    }
}

