/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4;

import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.signature.droid4.AnalysisController;
import uk.gov.nationalarchives.droid.core.signature.droid4.FileCollection;
import uk.gov.nationalarchives.droid.core.signature.droid4.IdentificationFile;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.AbstractByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile.FFSignatureFile;

public class AnalysisThread
extends Thread {
    private FileCollection myFileCollection;
    private FFSignatureFile mySigFile;
    private AnalysisController myAnalysisController;
    private int readTime = 0;
    private int algoTime = 0;
    private Log log = LogFactory.getLog(this.getClass());

    public AnalysisThread(FileCollection theFileCollection, FFSignatureFile theSigFile, AnalysisController theAnalysisController) {
        this.myFileCollection = theFileCollection;
        this.mySigFile = theSigFile;
        this.myAnalysisController = theAnalysisController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.myAnalysisController.setAnalysisStart();
        Iterator<IdentificationFile> it = this.myFileCollection.getIterator();
        while (it.hasNext() && !this.myAnalysisController.isAnalysisCancelled()) {
            IdentificationFile idFile = it.next();
            String idFileName = idFile.getFilePath();
            Date startRead = new Date();
            ByteReader testFile = null;
            try {
                try {
                    testFile = AbstractByteReader.newByteReader(idFile);
                }
                catch (OutOfMemoryError e) {
                    testFile = AbstractByteReader.newByteReader(idFile, false);
                    testFile.setErrorIdent();
                    testFile.setIdentificationWarning("The application ran out of memory while loading this file (" + e.toString() + ")");
                }
                Date endRead = new Date();
                this.readTime = (int)((long)this.readTime + (endRead.getTime() - startRead.getTime()));
                if (!testFile.isClassified()) {
                    Date startAlgo = new Date();
                    try {
                        this.mySigFile.runFileIdentification(testFile);
                    }
                    catch (Exception e) {
                        testFile.setErrorIdent();
                        testFile.setIdentificationWarning("Error during identification attempt: " + e.toString());
                    }
                    Date endAlgo = new Date();
                    this.algoTime = (int)((long)this.algoTime + (endAlgo.getTime() - startAlgo.getTime()));
                }
                if (this.myAnalysisController.isVerbose()) {
                    this.debugDisplayHits(testFile, idFileName);
                }
                this.myAnalysisController.incrNumCompletedFile();
            }
            finally {
                testFile.close();
            }
        }
        this.myAnalysisController.setAnalysisComplete();
    }

    private void debugDisplayHits(ByteReader testFile, String fileName) {
        System.out.println("==================================");
        this.log.info((Object)"==================================");
        if (testFile.isClassified()) {
            System.out.println("     " + fileName);
            this.log.info((Object)("     " + fileName));
            if (testFile.getIdentificationWarning().length() > 0) {
                System.out.println("with warning: " + testFile.getIdentificationWarning());
                this.log.info((Object)("with warning: " + testFile.getIdentificationWarning()));
            }
            for (int ih = 0; ih < testFile.getNumHits(); ++ih) {
                String specificityDisplay = testFile.getHit(ih).isSpecific() ? "specific" : "generic";
                System.out.println("          " + testFile.getHit(ih).getHitTypeVerbose() + " " + specificityDisplay + " hit for " + testFile.getHit(ih).getFileFormat().getName() + "  [PUID: " + testFile.getHit(ih).getFileFormat().getPUID() + "]" + "  [MIME: " + testFile.getHit(ih).getFileFormat().getMimeType() + "]");
                this.log.info((Object)("          " + testFile.getHit(ih).getHitTypeVerbose() + " " + specificityDisplay + " hit for " + testFile.getHit(ih).getFileFormat().getName() + "  [PUID: " + testFile.getHit(ih).getFileFormat().getPUID() + "]" + "  [MIME: " + testFile.getHit(ih).getFileFormat().getMimeType() + "]"));
                if (testFile.getHit(ih).getHitWarning().length() <= 0) continue;
                System.out.println("               WARNING: " + testFile.getHit(ih).getHitWarning());
                this.log.info((Object)("               WARNING: " + testFile.getHit(ih).getHitWarning()));
            }
        } else {
            System.out.println("     " + fileName + " was not classified");
            this.log.info((Object)("     " + fileName + " was not classified"));
        }
    }
}

