/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import uk.gov.nationalarchives.droid.core.signature.droid4.AnalysisController;
import uk.gov.nationalarchives.droid.core.signature.droid4.IdentificationFile;
import uk.gov.nationalarchives.droid.core.signature.droid4.IndexedHashSet;
import uk.gov.nationalarchives.droid.core.signature.droid4.MessageDisplay;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.InputStreamByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.UrlByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.xml.SimpleElement;

public class FileCollection
extends SimpleElement {
    private String myFileName = "DROID_filecollection.xml";
    private IndexedHashSet<Integer, IdentificationFile> myFiles = new IndexedHashSet();
    private int mySigFileVersion = 0;
    private long startTime;
    private long stopTime;
    private long lastNumFiles = -1L;

    public void setFileName(String theFileName) {
        this.myFileName = theFileName;
    }

    public Iterator<IdentificationFile> getIterator() {
        return this.myFiles.iterator();
    }

    public Enumeration getIndexKeys() {
        return this.myFiles.getIndexKeys();
    }

    public void addFile(String theFile, boolean isRecursive) {
        block10: {
            if (UrlByteReader.isURL(theFile)) {
                this.myFiles.add(this.getNumFiles(), new IdentificationFile(theFile));
                return;
            }
            if (InputStreamByteReader.isInputStream(theFile)) {
                this.myFiles.add(this.getNumFiles(), new IdentificationFile(theFile));
            }
            try {
                File f = new File(theFile);
                if (f.isDirectory()) {
                    File[] folderFiles = f.listFiles();
                    int numFiles = 0;
                    try {
                        numFiles = folderFiles.length;
                    }
                    catch (Exception e) {
                        MessageDisplay.generalWarning("Unable to read directory " + theFile + "\nThis may be because you do not have the correct permissions.");
                    }
                    for (int m = 0; m < numFiles; ++m) {
                        if (folderFiles[m].isFile()) {
                            IdentificationFile idFile = new IdentificationFile(folderFiles[m].getPath());
                            this.myFiles.add(this.getNumFiles(), idFile);
                            continue;
                        }
                        if (!folderFiles[m].isDirectory() || !isRecursive) continue;
                        this.addFile(folderFiles[m].getPath(), isRecursive);
                    }
                    break block10;
                }
                if (f.isFile()) {
                    IdentificationFile idFile = new IdentificationFile(f.getPath());
                    this.myFiles.add(this.getNumFiles(), idFile);
                }
            }
            catch (Exception e) {
                MessageDisplay.generalWarning("The following error occured while adding " + theFile + ":\n" + e.toString());
            }
        }
    }

    public void setFile(String theFile) {
        this.addFile(theFile, false);
    }

    public void removeFile(String theFileName) {
        IdentificationFile comparisonFile = new IdentificationFile(theFileName);
        this.myFiles.remove(comparisonFile);
    }

    public void removeFile(int theFileIndex) {
        this.myFiles.removeByIndex(theFileIndex);
    }

    public boolean containsIndex(int index) {
        return this.myFiles.containsKey(index);
    }

    public void removeAll() {
        this.myFiles.clear();
    }

    public String getFileName() {
        return this.myFileName;
    }

    public IdentificationFile getFile(int theIndex) {
        return (IdentificationFile)this.myFiles.get(theIndex);
    }

    public int getNumFiles() {
        return this.myFiles.size();
    }

    public void addIdentificationFile(IdentificationFile theFile) {
        this.myFiles.add(this.getNumFiles(), theFile);
    }

    @Override
    public void setAttributeValue(String theName, String theValue) {
        if (theName.equals("DROIDVersion")) {
            this.setDROIDVersion(theValue);
        } else if (theName.equals("SigFileVersion")) {
            this.setSignatureFileVersion(theValue);
        } else if (theName.equals("DateCreated")) {
            this.setDateCreated(theValue);
        } else {
            MessageDisplay.unknownAttributeWarning(theName, this.getElementName());
        }
    }

    public void setDROIDVersion(String value) {
        if (!value.equals(AnalysisController.getDROIDVersion())) {
            MessageDisplay.generalWarning("This file was generated with DROID version " + value + ".  Current version is " + AnalysisController.getDROIDVersion());
        }
    }

    public void setSignatureFileVersion(String value) {
        try {
            this.mySigFileVersion = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            MessageDisplay.generalWarning("The SigFileVersion attribute should be an integer");
        }
    }

    public void setDateCreated(String value) {
    }

    public int getLoadedFileSigFileVersion() {
        return this.mySigFileVersion;
    }
}

