/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4;

import uk.gov.nationalarchives.droid.core.signature.droid4.MessageDisplay;
import uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.droid4.xml.SimpleElement;

public class FileFormatHit
extends SimpleElement {
    String myHitWarning = "";
    int myHitType;
    FileFormat myHitFileFormat;

    public FileFormatHit(FileFormat theFileFormat, int theType, boolean theSpecificity, String theWarning) {
        this.myHitFileFormat = theFileFormat;
        this.myHitType = theType == 15 ? (theSpecificity ? 10 : 11) : theType;
        this.setIdentificationWarning(theWarning);
    }

    public FileFormatHit() {
    }

    public void setIdentificationWarning(String theWarning) {
        this.myHitWarning = theWarning;
    }

    public FileFormat getFileFormat() {
        return this.myHitFileFormat;
    }

    public String getFileFormatName() {
        return this.myHitFileFormat.getName();
    }

    public String getFileFormatVersion() {
        return this.myHitFileFormat.getVersion();
    }

    public String getMimeType() {
        return this.myHitFileFormat.getMimeType();
    }

    public String getFileFormatPUID() {
        return this.myHitFileFormat.getPUID();
    }

    public int getHitType() {
        return this.myHitType;
    }

    public String getHitTypeVerbose() {
        String theHitType = "";
        if (this.myHitType == 11) {
            theHitType = "Positive (Generic Format)";
        } else if (this.myHitType == 10) {
            theHitType = "Positive (Specific Format)";
        } else if (this.myHitType == 12) {
            theHitType = "Tentative";
        } else if (this.myHitType == 15) {
            theHitType = "Positive";
        }
        return theHitType;
    }

    public String getHitWarning() {
        return this.myHitWarning;
    }

    public boolean isSpecific() {
        return this.myHitType == 10;
    }

    @Override
    public void setAttributeValue(String theName, String theValue) {
        if (theName.equals("HitStatus")) {
            this.setStatus(theValue);
        } else if (theName.equals("FormatName")) {
            this.setName(theValue);
        } else if (theName.equals("FormatVersion")) {
            this.setVersion(theValue);
        } else if (theName.equals("FormatPUID")) {
            this.setPUID(theValue);
        } else if (theName.equals("HitWarning")) {
            this.setIdentificationWarning(theValue);
        } else {
            MessageDisplay.unknownAttributeWarning(theName, this.getElementName());
        }
    }

    public void setStatus(String value) {
        if (value.equals("Positive (Generic Format)")) {
            this.myHitType = 11;
        } else if (value.equals("Positive (Specific Format)")) {
            this.myHitType = 10;
        } else if (value.equals("Tentative")) {
            this.myHitType = 12;
        } else if (value.equals("Positive")) {
            this.myHitType = 15;
        } else {
            MessageDisplay.generalWarning("Unknown hit status listed: " + value);
        }
    }

    public void setName(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("Name", value);
    }

    public void setVersion(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("Version", value);
    }

    public void setPUID(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("PUID", value);
    }

    public void setMimeType(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("MIMEType", value);
    }
}

