/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public class IndexedHashSet<K, V>
extends HashSet<V> {
    private Hashtable<K, V> indexedTable;

    public IndexedHashSet(int initialCapacity) {
        super(initialCapacity);
        this.indexedTable = new Hashtable(initialCapacity);
    }

    public IndexedHashSet() {
        this.indexedTable = new Hashtable();
    }

    public synchronized boolean add(K key, V value) {
        if (super.add(value)) {
            this.indexedTable.put(key, value);
            return true;
        }
        return false;
    }

    public void removeByIndex(K index) {
        if (this.indexedTable.containsKey(index)) {
            V item = this.indexedTable.get(index);
            super.remove(item);
            this.indexedTable.remove(index);
        }
    }

    public boolean containsKey(K index) {
        return this.indexedTable.containsKey(index);
    }

    @Override
    public void clear() {
        this.indexedTable.clear();
        super.clear();
    }

    public synchronized Object get(K key) {
        return this.indexedTable.get(key);
    }

    public Enumeration getIndexKeys() {
        return this.indexedTable.keys();
    }
}

