/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4.bytereader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import uk.gov.nationalarchives.droid.core.signature.droid4.IdentificationFile;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.AbstractByteReader;

public class FileByteReader
extends AbstractByteReader {
    private int randomFileBufferSize = 100000000;
    private boolean isRandomAccess = false;
    protected byte[] fileBytes;
    private long numBytes;
    private long fileMarker;
    private RandomAccessFile randomAccessFile = null;
    private long rAFoffset = 0L;
    private static final int MIN_RAF_BUFFER_SIZE = 1000000;
    private static final int RAF_BUFFER_REDUCTION_FACTOR = 2;
    private File file;

    FileByteReader(IdentificationFile theIDFile, boolean readFile, String filePath) {
        super(theIDFile);
        this.file = new File(filePath);
        if (readFile) {
            this.readFile();
        }
    }

    FileByteReader(IdentificationFile theIDFile, boolean readFile) {
        this(theIDFile, readFile, theIDFile.getFilePath());
    }

    public boolean isRandomAccess() {
        return this.isRandomAccess;
    }

    public int getRandomFileBufferSize() {
        return this.randomFileBufferSize;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile() {
        FileInputStream binStream;
        if (!this.file.exists()) {
            this.setErrorIdent();
            this.setIdentificationWarning("File does not exist");
            return;
        }
        if (!this.file.canRead()) {
            this.setErrorIdent();
            this.setIdentificationWarning("File cannot be read");
            return;
        }
        if (this.file.isDirectory()) {
            this.setErrorIdent();
            this.setIdentificationWarning("This is a directory, not a file");
            return;
        }
        try {
            binStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            this.setErrorIdent();
            this.setIdentificationWarning("File disappeared or cannot be read");
            return;
        }
        BufferedInputStream buffStream = null;
        try {
            int numBytes = binStream.available();
            if (numBytes > 0) {
                this.fileBytes = new byte[numBytes];
                buffStream = new BufferedInputStream(binStream);
                int len = buffStream.read(this.fileBytes, 0, numBytes);
                if (len != numBytes) {
                    this.setErrorIdent();
                    this.setIdentificationWarning("Error reading file: " + len + " bytes read from file when " + numBytes + " were expected");
                } else if (buffStream.read() != -1) {
                    this.setErrorIdent();
                    this.setIdentificationWarning("Error reading file: Unable to read to the end");
                } else {
                    this.numBytes = numBytes;
                }
            } else {
                this.numBytes = 0L;
                this.setIdentificationWarning("Zero-length file");
            }
            this.isRandomAccess = false;
        }
        catch (IOException e) {
            this.setErrorIdent();
            this.setIdentificationWarning("Error reading file: " + e.toString());
        }
        catch (OutOfMemoryError e) {
            try {
                this.randomAccessFile = new RandomAccessFile(this.file, "r");
                this.isRandomAccess = true;
                this.numBytes = this.randomAccessFile.length();
                this.randomAccessFile.seek(0L);
                boolean tryAgain = true;
                while (tryAgain) {
                    try {
                        this.fileBytes = new byte[this.randomFileBufferSize];
                        this.randomAccessFile.read(this.fileBytes);
                        tryAgain = false;
                    }
                    catch (OutOfMemoryError e4) {
                        this.randomFileBufferSize /= 2;
                        if (this.randomFileBufferSize >= 1000000) continue;
                        throw e4;
                    }
                }
                this.rAFoffset = 0L;
            }
            catch (FileNotFoundException e2) {
                this.setErrorIdent();
                this.setIdentificationWarning("File disappeared or cannot be read");
            }
            catch (Exception e2) {
                this.setErrorIdent();
                this.setIdentificationWarning("Error reading file: " + e2.toString());
            }
        }
        finally {
            if (buffStream != null) {
                try {
                    buffStream.close();
                }
                catch (IOException e) {
                    this.setErrorIdent();
                    this.setIdentificationWarning("Unable to close file: " + e.getMessage());
                }
            }
            if (binStream != null) {
                try {
                    binStream.close();
                }
                catch (IOException e) {
                    this.setErrorIdent();
                    this.setIdentificationWarning("Unable to close file: " + e.getMessage());
                }
            }
            if (this.randomAccessFile != null) {
                try {
                    this.randomAccessFile.close();
                }
                catch (IOException e) {
                    this.setErrorIdent();
                    this.setIdentificationWarning("Unable to close file: " + e.getMessage());
                }
            }
        }
    }

    @Override
    public void setFileMarker(long markerPosition) {
        if (markerPosition < -1L || markerPosition > this.getNumBytes()) {
            throw new IllegalArgumentException("  Unable to place a fileMarker at byte " + Long.toString(markerPosition) + " in file " + this.myIDFile.getFilePath() + " (size = " + Long.toString(this.getNumBytes()) + " bytes)");
        }
        this.fileMarker = markerPosition;
    }

    @Override
    public long getFileMarker() {
        return this.fileMarker;
    }

    @Override
    public byte getByte(long fileIndex) {
        byte theByte = 0;
        if (this.isRandomAccess) {
            long theArrayIndex = fileIndex - this.rAFoffset;
            if (fileIndex >= this.rAFoffset && theArrayIndex < (long)this.randomFileBufferSize) {
                theByte = this.fileBytes[(int)theArrayIndex];
            } else {
                try {
                    this.rAFoffset = fileIndex < (long)this.randomFileBufferSize ? 0L : (fileIndex < this.rAFoffset ? fileIndex - (long)this.randomFileBufferSize + 1L : fileIndex);
                    this.randomAccessFile.seek(this.rAFoffset);
                    this.randomAccessFile.read(this.fileBytes);
                    theByte = this.fileBytes[(int)(fileIndex - this.rAFoffset)];
                }
                catch (Exception e) {}
            }
        } else if (this.fileBytes != null) {
            theByte = this.fileBytes[(int)fileIndex];
        }
        return theByte;
    }

    @Override
    public long getNumBytes() {
        return this.numBytes;
    }

    @Override
    public byte[] getbuffer() {
        return this.fileBytes;
    }

    @Override
    public void close() {
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException e) {
                this.setErrorIdent();
                this.setIdentificationWarning("Unable to close file: " + e.getMessage());
            }
            this.randomAccessFile = null;
        }
    }
}

