/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile;

import java.util.ArrayList;
import java.util.List;
import uk.gov.nationalarchives.droid.core.signature.droid4.FileFormatHit;
import uk.gov.nationalarchives.droid.core.signature.droid4.MessageDisplay;
import uk.gov.nationalarchives.droid.core.signature.droid4.bytereader.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile.ByteSequence;
import uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile.FileFormatCollection;
import uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile.InternalSignature;
import uk.gov.nationalarchives.droid.core.signature.droid4.signaturefile.InternalSignatureCollection;
import uk.gov.nationalarchives.droid.core.signature.droid4.xml.SimpleElement;

public class FFSignatureFile
extends SimpleElement {
    private String version = "";
    private String dateCreated = "";
    private FileFormatCollection FFcollection;
    private InternalSignatureCollection intSigs;

    public void setFileFormatCollection(FileFormatCollection coll) {
        this.FFcollection = coll;
    }

    public void setInternalSignatureCollection(InternalSignatureCollection col3) {
        this.intSigs = col3;
    }

    private void setVersion(String vers) {
        this.version = vers;
    }

    private void setDateCreated(String dc) {
        this.dateCreated = dc;
    }

    @Override
    public void setAttributeValue(String name, String value) {
        if (name.equals("Version")) {
            this.setVersion(value.trim());
        } else if (name.equals("DateCreated")) {
            this.setDateCreated(value);
        } else {
            MessageDisplay.unknownAttributeWarning(name, this.getElementName());
        }
    }

    public int getNumInternalSignatures() {
        return this.intSigs.getInternalSignatures().size();
    }

    public List<InternalSignature> getSignatures() {
        return this.intSigs.getInternalSignatures();
    }

    public InternalSignature getInternalSignature(int theIndex) {
        return this.intSigs.getInternalSignatures().get(theIndex);
    }

    public int getNumFileFormats() {
        return this.FFcollection.getFileFormats().size();
    }

    public FileFormat getFileFormat(int theIndex) {
        return (FileFormat)this.FFcollection.getFileFormats().get(theIndex);
    }

    public String getVersion() {
        return this.version;
    }

    public String getDateCreated() {
        return this.dateCreated;
    }

    public void prepareForUse() {
        this.setAllSignatureFileFormats();
        this.reorderAllSequenceFragments();
        this.reorderByteSequences();
    }

    private void setAllSignatureFileFormats() {
        for (int iFormat = 0; iFormat < this.getNumFileFormats(); ++iFormat) {
            block1: for (int iFileSig = 0; iFileSig < this.getFileFormat(iFormat).getNumInternalSignatures(); ++iFileSig) {
                int iFileSigID = this.getFileFormat(iFormat).getInternalSignatureID(iFileSig);
                for (int iIntSig = 0; iIntSig < this.getNumInternalSignatures(); ++iIntSig) {
                    if (this.getInternalSignature(iIntSig).getID() != iFileSigID) continue;
                    this.getInternalSignature(iIntSig).addFileFormat(this.getFileFormat(iFormat));
                    continue block1;
                }
            }
        }
    }

    private void reorderAllSequenceFragments() {
        for (int iSig = 0; iSig < this.getNumInternalSignatures(); ++iSig) {
            for (int iBS = 0; iBS < this.getInternalSignature(iSig).getNumByteSequences(); ++iBS) {
                for (int iSS = 0; iSS < this.getInternalSignature(iSig).getByteSequence(iBS).getNumSubSequences(); ++iSS) {
                    this.getInternalSignature(iSig).getByteSequence(iBS).getSubSequence(iSS).prepareSeqFragments();
                }
            }
        }
    }

    private void reorderByteSequences() {
        for (int iSig = 0; iSig < this.getNumInternalSignatures(); ++iSig) {
            InternalSignature sig = this.getInternalSignature(iSig);
            ArrayList<ByteSequence> BOFoffsetByteSequences = new ArrayList<ByteSequence>();
            ArrayList<ByteSequence> EOFoffsetByteSequences = new ArrayList<ByteSequence>();
            ArrayList<ByteSequence> variableByteSequences = new ArrayList<ByteSequence>();
            for (int iBS = 0; iBS < sig.getNumByteSequences(); ++iBS) {
                ByteSequence seq = sig.getByteSequence(iBS);
                if (seq.getReference().startsWith("BOF")) {
                    BOFoffsetByteSequences.add(seq);
                }
                if (seq.getReference().startsWith("EOF")) {
                    EOFoffsetByteSequences.add(seq);
                    continue;
                }
                variableByteSequences.add(seq);
            }
            ArrayList<ByteSequence> byteSequences = new ArrayList<ByteSequence>();
            byteSequences.addAll(BOFoffsetByteSequences);
            byteSequences.addAll(EOFoffsetByteSequences);
            byteSequences.addAll(variableByteSequences);
            sig.resetByteSequences(byteSequences);
        }
    }

    public synchronized void runFileIdentification(ByteReader targetFile) {
        List<InternalSignature> signatureList = this.getSignatures();
        for (InternalSignature internalSig : signatureList) {
            if (!internalSig.isFileCompliant(targetFile)) continue;
            targetFile.setPositiveIdent();
            for (int i = 0; i < internalSig.getNumFileFormats(); ++i) {
                FileFormatHit fileHit = new FileFormatHit(internalSig.getFileFormat(i), 15, internalSig.isSpecific(), "");
                targetFile.addHit(fileHit);
            }
        }
        if (targetFile.getNumHits() > 1) {
            this.removeLowerPriorityHits(targetFile);
        }
        this.checkExtension(targetFile);
        if (targetFile.getNumHits() == 0) {
            targetFile.setNoIdent();
        }
    }

    private void removeLowerPriorityHits(ByteReader targetFile) {
        ArrayList<Integer> hitsToRemove = new ArrayList<Integer>();
        for (int i = 0; i < targetFile.getNumHits(); ++i) {
            block1: for (int j = 0; j < targetFile.getHit(i).getFileFormat().getNumHasPriorityOver(); ++j) {
                int formatID = targetFile.getHit(i).getFileFormat().getHasPriorityOver(j);
                for (int k = 0; k < targetFile.getNumHits(); ++k) {
                    if (targetFile.getHit(k).getFileFormat().getID() != formatID) continue;
                    hitsToRemove.add(k);
                    continue block1;
                }
            }
        }
        int[] indexesOfHits = new int[hitsToRemove.size()];
        int numHitsToRemove = 0;
        for (Integer aHitsToRemove : hitsToRemove) {
            int indexOfHit = aHitsToRemove;
            for (int j = numHitsToRemove; j > 0 && indexesOfHits[j - 1] > indexOfHit; --j) {
                indexesOfHits[j] = indexesOfHits[j - 1];
            }
            indexesOfHits[j] = indexOfHit;
            ++numHitsToRemove;
        }
        for (int i = indexesOfHits.length - 1; i >= 0; --i) {
            if (i == indexesOfHits.length - 1) {
                targetFile.removeHit(indexesOfHits[i]);
                continue;
            }
            if (indexesOfHits[i] == indexesOfHits[i + 1]) continue;
            targetFile.removeHit(indexesOfHits[i]);
        }
    }

    private void checkExtension(ByteReader targetFile) {
        boolean hasExtension = true;
        int dotPos = targetFile.getFileName().lastIndexOf(".");
        if (dotPos < 0) {
            hasExtension = false;
        } else if (dotPos == targetFile.getFileName().length() - 1) {
            hasExtension = false;
        } else if (targetFile.getFileName().lastIndexOf("/") > dotPos) {
            hasExtension = false;
        } else if (targetFile.getFileName().lastIndexOf("\\") > dotPos) {
            hasExtension = false;
        }
        if (hasExtension) {
            String fileExtension = targetFile.getFileName().substring(dotPos + 1);
            if (targetFile.getNumHits() > 0) {
                for (int iHit = 0; iHit < targetFile.getNumHits(); ++iHit) {
                    if (targetFile.getHit(iHit).getFileFormat().hasMatchingExtension(fileExtension)) continue;
                    targetFile.getHit(iHit).setIdentificationWarning(MessageDisplay.FILEEXTENSIONWARNING);
                }
            } else {
                for (int iFormat = 0; iFormat < this.getNumFileFormats(); ++iFormat) {
                    if (this.getFileFormat(iFormat).getNumInternalSignatures() != 0 || !this.getFileFormat(iFormat).hasMatchingExtension(fileExtension)) continue;
                    FileFormatHit fileHit = new FileFormatHit(this.getFileFormat(iFormat), 12, false, "");
                    targetFile.addHit(fileHit);
                    targetFile.setTentativeIdent();
                }
            }
        } else {
            for (int iHit = 0; iHit < targetFile.getNumHits(); ++iHit) {
                targetFile.getHit(iHit).setIdentificationWarning(MessageDisplay.FILEEXTENSIONWARNING);
            }
        }
    }
}

