/*
 * Decompiled with CFR 0.152.
 */
package beowulf.applications.fviewer;

import beowulf.applications.fviewer.FViewer;
import beowulf.gui.JFunction;
import beowulf.gui.Utility;
import beowulf.model.math.function.Constant;
import beowulf.model.math.function.EmptyFunction;
import beowulf.model.math.function.Function;
import beowulf.model.math.function.Power;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class Actions {
    public static EditNodeAction getEditNodeInstance(FViewer fViewer) {
        if (EditNodeAction.action == null) {
            EditNodeAction.action = new EditNodeAction(fViewer);
        }
        return EditNodeAction.action;
    }

    public static GetDerivativeAction getGetDerivativeInstance(FViewer fViewer) {
        if (GetDerivativeAction.action == null) {
            GetDerivativeAction.action = new GetDerivativeAction(fViewer);
        }
        return GetDerivativeAction.action;
    }

    public static AddFunctionAction getAddFunctionInstance(FViewer fViewer) {
        if (AddFunctionAction.action == null) {
            AddFunctionAction.action = new AddFunctionAction(fViewer);
        }
        return AddFunctionAction.action;
    }

    public static UpdateFunctionAction getUpdateFunctionInstance(FViewer fViewer) {
        if (UpdateFunctionAction.action == null) {
            UpdateFunctionAction.action = new UpdateFunctionAction(fViewer);
        }
        return UpdateFunctionAction.action;
    }

    public static SaveFunctionAction getSaveFunctionInstance(FViewer fViewer) {
        if (SaveFunctionAction.action == null) {
            SaveFunctionAction.action = new SaveFunctionAction(fViewer);
        }
        return SaveFunctionAction.action;
    }

    public static OpenFunctionAction getLoadFunctionInstance(FViewer fViewer) {
        if (OpenFunctionAction.action == null) {
            OpenFunctionAction.action = new OpenFunctionAction(fViewer);
        }
        return OpenFunctionAction.action;
    }

    public static DeleteNodeAction getRemoveNodeInstance(FViewer fViewer) {
        if (DeleteNodeAction.action == null) {
            DeleteNodeAction.action = new DeleteNodeAction(fViewer);
        }
        return DeleteNodeAction.action;
    }

    public static RemoveFunctionAction getRemoveFunctionInstance(FViewer fViewer) {
        if (RemoveFunctionAction.action == null) {
            RemoveFunctionAction.action = new RemoveFunctionAction(fViewer);
        }
        return RemoveFunctionAction.action;
    }

    public static ExitAction getExitInstance(FViewer fViewer) {
        if (ExitAction.action == null) {
            ExitAction.action = new ExitAction(fViewer);
        }
        return ExitAction.action;
    }

    public static CutNodeAction getCutNodeInstance(FViewer fViewer) {
        if (CutNodeAction.action == null) {
            CutNodeAction.action = new CutNodeAction(fViewer);
        }
        return CutNodeAction.action;
    }

    public static PasteNodeAction getPasteNodeInstance(FViewer fViewer) {
        if (PasteNodeAction.action == null) {
            PasteNodeAction.action = new PasteNodeAction(fViewer);
        }
        return PasteNodeAction.action;
    }

    public static CopyNodeAction getCopyNodeInstance(FViewer fViewer) {
        if (CopyNodeAction.action == null) {
            CopyNodeAction.action = new CopyNodeAction(fViewer);
        }
        return CopyNodeAction.action;
    }

    static class CutNodeAction
    extends ClipboardAction {
        private static final long serialVersionUID = 3257572793242824760L;
        static CutNodeAction action;

        protected CutNodeAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Cut Node");
            this.putValue("MnemonicKey", new Integer(84));
            this.putValue("ShortDescription", "Cut the selected node to the clipboard");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TreePath treePath = this.parent.treeDisplay.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                Function function = (Function)treePath.getLastPathComponent();
                if (function == this.parent.treeModel.getRoot()) {
                    throw new RuntimeException("Cannot cut root node");
                }
                Function function2 = this.parent.treeModel.getParent(function);
                int n = this.parent.treeModel.getIndexOfChild(function2, function);
                this.parent.treeModel.insert(function2, new EmptyFunction(), n);
                clipboard = function;
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }
    }

    static class CopyNodeAction
    extends ClipboardAction {
        private static final long serialVersionUID = 3546922497967798583L;
        static CopyNodeAction action;

        protected CopyNodeAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Copy Node");
            this.putValue("MnemonicKey", new Integer(67));
            this.putValue("ShortDescription", "Copy the selected node to the clipboard");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TreePath treePath = this.parent.treeDisplay.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                Function function = (Function)treePath.getLastPathComponent();
                clipboard = (Function)function.clone();
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }
    }

    static class PasteNodeAction
    extends ClipboardAction {
        private static final long serialVersionUID = 3834594305167144247L;
        static PasteNodeAction action;

        protected PasteNodeAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Paste Node");
            this.putValue("MnemonicKey", new Integer(80));
            this.putValue("ShortDescription", "Paste the clipboard contents over the selected node");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TreePath treePath = this.parent.treeDisplay.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                Function function = (Function)treePath.getLastPathComponent();
                Function function2 = this.parent.treeModel.getParent(function);
                if (function2 == null) {
                    this.parent.treeModel.setRoot((Function)clipboard.clone());
                } else {
                    int n = this.parent.treeModel.getIndexOfChild(function2, function);
                    this.parent.treeModel.insert(function2, (Function)clipboard.clone(), n);
                }
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }
    }

    static abstract class ClipboardAction
    extends AbstractAction {
        protected static Function clipboard;
        protected FViewer parent;

        ClipboardAction() {
        }
    }

    static class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 3256725099875743287L;
        static ExitAction action;
        protected FViewer parent;

        protected ExitAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Exit");
            this.putValue("MnemonicKey", new Integer(88));
            this.putValue("ShortDescription", "Exit the application");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                System.exit(0);
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }
    }

    static class RemoveFunctionAction
    extends AbstractAction {
        private static final long serialVersionUID = 3689347732376466227L;
        static RemoveFunctionAction action;
        protected FViewer parent;

        protected RemoveFunctionAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Remove Function");
            this.putValue("ShortDescription", "Remove the currently selected function from the list");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JFunction.FunctionData functionData = (JFunction.FunctionData)this.parent.functionList.getSelectedItem();
                if (functionData == null) {
                    return;
                }
                this.parent.functionList.removeElement(functionData);
                this.parent.panel.removeFunction(functionData);
                this.parent.repaint();
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }
    }

    static class DeleteNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 3976736965003392819L;
        static DeleteNodeAction action;
        protected FViewer parent;

        protected DeleteNodeAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Delete Node");
            this.putValue("MnemonicKey", new Integer(68));
            this.putValue("ShortDescription", "Delete the currently selected node");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TreePath treePath = this.parent.treeDisplay.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                Function function = (Function)treePath.getLastPathComponent();
                if (function == this.parent.treeModel.getRoot()) {
                    throw new RuntimeException("Cannot remove root node");
                }
                Function function2 = this.parent.treeModel.getParent(function);
                int n = this.parent.treeModel.getIndexOfChild(function2, function);
                this.parent.treeModel.insert(function2, new EmptyFunction(), n);
                this.parent.repaint();
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }
    }

    static class OpenFunctionAction
    extends AbstractAction {
        private static final long serialVersionUID = 3257850961061163832L;
        static OpenFunctionAction action;
        protected JFileChooser chooser = new JFileChooser();
        protected FViewer parent;

        protected OpenFunctionAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Open Function...");
            this.putValue("MnemonicKey", new Integer(79));
            this.putValue("ShortDescription", "Open a serialized function");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
            this.chooser.setFileSelectionMode(0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this.chooser.showOpenDialog(this.parent) != 0) {
                    return;
                }
                File file = this.chooser.getSelectedFile();
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                JFunction.FunctionData functionData = new JFunction.FunctionData();
                functionData.f = (Function)objectInputStream.readObject();
                functionData.color = this.parent.colorButton.getBackground();
                functionData.steps = Integer.parseInt(this.parent.stepBox.getText());
                functionData.visible = this.parent.visibleBox.isSelected();
                this.parent.functionList.addElement(functionData);
                this.parent.panel.addFunction(functionData);
                this.parent.functionList.setSelectedItem(functionData);
                this.parent.treeModel.setRoot(functionData.f);
                objectInputStream.close();
                this.parent.repaint();
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }
    }

    static class SaveFunctionAction
    extends AbstractAction {
        private static final long serialVersionUID = 3257281414088308530L;
        static SaveFunctionAction action;
        protected JFileChooser chooser = new JFileChooser();
        protected FViewer parent;

        protected SaveFunctionAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Save Function...");
            this.putValue("MnemonicKey", new Integer(83));
            this.putValue("ShortDescription", "Save the currently selected function");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
            this.chooser.setFileSelectionMode(0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JFunction.FunctionData functionData = (JFunction.FunctionData)this.parent.functionList.getSelectedItem();
                if (functionData == null) {
                    return;
                }
                if (this.chooser.showSaveDialog(this.parent) != 0) {
                    return;
                }
                File file = this.chooser.getSelectedFile();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                objectOutputStream.writeObject(functionData.f);
                objectOutputStream.close();
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }
    }

    static class EditNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 3258125843397228086L;
        static EditNodeAction action;
        protected FViewer parent;

        protected EditNodeAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Edit Node");
            this.putValue("MnemonicKey", new Integer(69));
            this.putValue("ShortDescription", "Edit the currently selected node");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TreePath treePath = this.parent.treeDisplay.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                Function function = (Function)treePath.getLastPathComponent();
                if (function instanceof Constant) {
                    this.editConstant((Constant)function);
                } else if (function instanceof Power) {
                    this.editPower((Power)function);
                }
                this.parent.repaint();
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }

        private void editConstant(Constant constant) {
            String string = JOptionPane.showInputDialog(this.parent, "Enter the new constant value", Double.toString(constant.getValue()));
            if (string == null || string.length() == 0) {
                return;
            }
            constant.setValue(Double.parseDouble(string));
        }

        private void editPower(Power power) {
            String string = JOptionPane.showInputDialog(this.parent, "Enter the new exponent value", Double.toString(power.getPower()));
            if (string == null || string.length() == 0) {
                return;
            }
            power.setPower(Double.parseDouble(string));
        }
    }

    static class UpdateFunctionAction
    extends AbstractAction {
        private static final long serialVersionUID = 3257003246286289208L;
        static UpdateFunctionAction action;
        protected FViewer parent;

        protected UpdateFunctionAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Update Function");
            this.putValue("ShortDescription", "Update the display parameters of the currently selected function");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JFunction.FunctionData functionData = (JFunction.FunctionData)this.parent.functionList.getSelectedItem();
                if (functionData != null) {
                    functionData.steps = Integer.parseInt(this.parent.stepBox.getText());
                    functionData.visible = this.parent.visibleBox.isSelected();
                    functionData.color = this.parent.colorButton.getBackground();
                }
                this.parent.repaint();
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }
    }

    static class AddFunctionAction
    extends AbstractAction {
        private static final long serialVersionUID = 3546925770766037811L;
        static AddFunctionAction action;
        protected FViewer parent;

        protected AddFunctionAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Add Function");
            this.putValue("MnemonicKey", new Integer(65));
            this.putValue("ShortDescription", "Add the function in the tree to the list of displayed functions");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JFunction.FunctionData functionData = new JFunction.FunctionData();
                functionData.f = (Function)((Function)this.parent.treeModel.getRoot()).clone();
                functionData.color = this.parent.colorButton.getBackground();
                functionData.steps = Integer.parseInt(this.parent.stepBox.getText());
                functionData.visible = this.parent.visibleBox.isSelected();
                this.parent.functionList.addElement(functionData);
                this.parent.panel.addFunction(functionData);
                this.parent.functionList.setSelectedItem(functionData);
                this.parent.repaint();
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }
    }

    static class GetDerivativeAction
    extends AbstractAction {
        private static final long serialVersionUID = 3257850995437483057L;
        static GetDerivativeAction action;
        protected FViewer parent;

        protected GetDerivativeAction(FViewer fViewer) {
            this.parent = fViewer;
            this.putValue("Name", "Deriv. Function");
            this.putValue("MnemonicKey", new Integer(86));
            this.putValue("ShortDescription", "Replace the tree function with it's derivative");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Function function = (Function)this.parent.treeModel.getRoot();
                this.parent.treeModel.setRoot(function.getDerivative());
            }
            catch (Exception exception) {
                Utility.showExceptionDialog(this.parent, exception);
            }
        }
    }
}

