/*
 * Decompiled with CFR 0.152.
 */
package beowulf.gui;

import beowulf.event.DraggableComponentSelectionEvent;
import beowulf.event.DraggableComponentSelectionListener;
import beowulf.gui.DraggableComponent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DraggableContainer
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = 4121976970738481207L;
    protected DraggableComponent currentComponent;
    protected Vector listenerList = new Vector();

    public DraggableComponent getCurrentComponent() {
        return this.currentComponent;
    }

    public void setCurrentComponent(DraggableComponent draggableComponent) {
        if (this.currentComponent != null) {
            this.fireComponentDeselected(this.currentComponent);
        }
        this.currentComponent = draggableComponent;
        if (this.currentComponent != null) {
            this.fireComponentSelected(this.currentComponent);
        }
    }

    public void addDraggableComponentSelectionListener(DraggableComponentSelectionListener draggableComponentSelectionListener) {
        this.listenerList.add(draggableComponentSelectionListener);
    }

    public void removeDraggableComponentSelectionListener(DraggableComponentSelectionListener draggableComponentSelectionListener) {
        this.listenerList.remove(draggableComponentSelectionListener);
    }

    protected void fireComponentSelected(DraggableComponent draggableComponent) {
        DraggableComponentSelectionEvent draggableComponentSelectionEvent = new DraggableComponentSelectionEvent(this, 1, draggableComponent);
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ((DraggableComponentSelectionListener)this.listenerList.get(i)).valueChanged(draggableComponentSelectionEvent);
        }
    }

    protected void fireComponentDeselected(DraggableComponent draggableComponent) {
        DraggableComponentSelectionEvent draggableComponentSelectionEvent = new DraggableComponentSelectionEvent(this, 2, draggableComponent);
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ((DraggableComponentSelectionListener)this.listenerList.get(i)).valueChanged(draggableComponentSelectionEvent);
        }
    }

    public DraggableContainer() {
        this.setLayout(null);
        this.addMouseListener(this);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.setCurrentComponent(null);
            this.getTopLevelAncestor().repaint();
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public Component add(Component component) {
        if (component instanceof DraggableComponent) {
            return super.add(component);
        }
        return null;
    }

    public Component add(String string, Component component) {
        if (component instanceof DraggableComponent) {
            return super.add(string, component);
        }
        return null;
    }

    public Component add(Component component, int n) {
        if (component instanceof DraggableComponent) {
            return super.add(component, n);
        }
        return null;
    }

    public void add(Component component, Object object) {
        if (component instanceof DraggableComponent) {
            super.add(component, object);
        }
    }

    public void add(Component component, Object object, int n) {
        if (component instanceof DraggableComponent) {
            super.add(component, object, n);
        }
    }
}

